/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;
import org.neo4j.kernel.api.impl.schema.ValueEncoding;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class LuceneDocumentStructure {
    private static final boolean USE_LUCENE_STANDARD_PREFIX_QUERY = FeatureToggles.flag(LuceneDocumentStructure.class, "lucene.standard.prefix.query", false);
    public static final String NODE_ID_KEY = "id";
    private static final int MAX_FIELD_LENGTH = 32766;
    private static final ThreadLocal<DocWithId> perThreadDocument = new ThreadLocal<DocWithId>(){

        @Override
        protected DocWithId initialValue() {
            return new DocWithId(LuceneDocumentStructure.NODE_ID_KEY);
        }
    };

    private LuceneDocumentStructure() {
    }

    private static DocWithId reuseDocument(long nodeId) {
        DocWithId doc2 = perThreadDocument.get();
        doc2.setId(nodeId);
        return doc2;
    }

    public static Document documentRepresentingProperty(long nodeId, Object value) {
        DocWithId document = LuceneDocumentStructure.reuseDocument(nodeId);
        document.setValue(ValueEncoding.forValue(value), value);
        return document.document;
    }

    public static String encodedStringValue(Object value) {
        ValueEncoding encoding = ValueEncoding.forValue(value);
        Field field2 = encoding.encodeField(value);
        return field2.stringValue();
    }

    public static MatchAllDocsQuery newScanQuery() {
        return new MatchAllDocsQuery();
    }

    public static Query newSeekQuery(Object value) {
        ValueEncoding encoding = ValueEncoding.forValue(value);
        return encoding.encodeQuery(value);
    }

    public static NumericRangeQuery<Double> newInclusiveNumericRangeSeekQuery(Number lower, Number upper) {
        Double min2 = lower != null ? Double.valueOf(lower.doubleValue()) : null;
        Double max2 = upper != null ? Double.valueOf(upper.doubleValue()) : null;
        return NumericRangeQuery.newDoubleRange(ValueEncoding.Number.key(), min2, max2, true, true);
    }

    public static Query newRangeSeekByStringQuery(String lower, boolean includeLower, String upper, boolean includeUpper) {
        boolean includeLowerBoundary = "".equals(lower) || includeLower;
        boolean includeUpperBoundary = "".equals(upper) || includeUpper;
        TermRangeQuery termRangeQuery = TermRangeQuery.newStringRange(ValueEncoding.String.key(), lower, upper, includeLowerBoundary, includeUpperBoundary);
        if (includeLowerBoundary != includeLower || includeUpperBoundary != includeUpper) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            if (includeLowerBoundary != includeLower) {
                builder.add(new TermQuery(new Term(ValueEncoding.String.key(), lower)), BooleanClause.Occur.MUST_NOT);
            }
            if (includeUpperBoundary != includeUpper) {
                builder.add(new TermQuery(new Term(ValueEncoding.String.key(), upper)), BooleanClause.Occur.MUST_NOT);
            }
            builder.add(termRangeQuery, BooleanClause.Occur.SHOULD);
            return builder.build();
        }
        return new ConstantScoreQuery(termRangeQuery);
    }

    public static Query newWildCardStringQuery(String searchFor) {
        String searchTerm = QueryParser.escape(searchFor);
        Term term = new Term(ValueEncoding.String.key(), "*" + searchTerm + "*");
        return new WildcardQuery(term);
    }

    public static Query newRangeSeekByPrefixQuery(String prefix) {
        Term term = new Term(ValueEncoding.String.key(), prefix);
        MultiTermQuery prefixQuery = USE_LUCENE_STANDARD_PREFIX_QUERY ? new PrefixQuery(term) : new PrefixMultiTermsQuery(term);
        return new ConstantScoreQuery(prefixQuery);
    }

    public static Query newSuffixStringQuery(String suffix) {
        String searchTerm = QueryParser.escape(suffix);
        Term term = new Term(ValueEncoding.String.key(), "*" + searchTerm);
        return new WildcardQuery(term);
    }

    public static Term newTermForChangeOrRemove(long nodeId) {
        return new Term(NODE_ID_KEY, "" + nodeId);
    }

    public static long getNodeId(Document from2) {
        return Long.parseLong(from2.get(NODE_ID_KEY));
    }

    public static TermsEnum originalTerms(Terms terms, String fieldKey) throws IOException {
        TermsEnum termsEnum = terms.iterator();
        return ValueEncoding.forKey(fieldKey) == ValueEncoding.Number ? NumericUtils.filterPrefixCodedLongs(termsEnum) : termsEnum;
    }

    private static class DocWithId {
        private final Document document;
        private final String idFieldName;
        private final Field idField;
        private final Field idValueField;
        private final Map<ValueEncoding, Field> valueFields = new EnumMap<ValueEncoding, Field>(ValueEncoding.class);

        private DocWithId(String idFieldName) {
            this.idFieldName = idFieldName;
            this.idField = new StringField(idFieldName, "", Field.Store.YES);
            this.idValueField = new NumericDocValuesField(idFieldName, 0L);
            this.document = new Document();
            this.document.add(this.idField);
            this.document.add(this.idValueField);
        }

        private void setId(long id) {
            this.idField.setStringValue("" + id);
            this.idValueField.setLongValue(id);
        }

        private void setValue(ValueEncoding encoding, Object value) {
            this.removeAllValueFields();
            Field reusableField = this.getFieldWithValue(encoding, value);
            if (this.isArrayOrString(reusableField)) {
                if (this.isShorterThenMaximum(reusableField)) {
                    this.document.add(reusableField);
                }
            } else {
                this.document.add(reusableField);
            }
        }

        private boolean isShorterThenMaximum(Field reusableField) {
            return reusableField.stringValue().getBytes().length <= 32766;
        }

        private boolean isArrayOrString(Field reusableField) {
            return ValueEncoding.Array.key().equals(reusableField.name()) || ValueEncoding.String.key().equals(reusableField.name());
        }

        private void removeAllValueFields() {
            Iterator<IndexableField> it = this.document.getFields().iterator();
            while (it.hasNext()) {
                IndexableField field2 = it.next();
                String fieldName = field2.name();
                if (fieldName.equals(this.idFieldName)) continue;
                it.remove();
            }
        }

        private Field getFieldWithValue(ValueEncoding encoding, Object value) {
            Field reusableField = this.valueFields.get((Object)encoding);
            if (reusableField == null) {
                reusableField = encoding.encodeField(value);
                this.valueFields.put(encoding, reusableField);
            } else {
                encoding.setFieldValue(value, reusableField);
            }
            return reusableField;
        }
    }

    private static class PrefixMultiTermsQuery
    extends MultiTermQuery {
        private Term term;

        PrefixMultiTermsQuery(Term term) {
            super(term.field());
            this.term = term;
        }

        @Override
        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return this.term.bytes().length == 0 ? terms.iterator() : new PrefixTermsEnum(terms.iterator(), this.term.bytes());
        }

        @Override
        public String toString(String field2) {
            return this.getClass().getSimpleName() + ", term:" + this.term + ", field:" + field2;
        }

        private class PrefixTermsEnum
        extends FilteredTermsEnum {
            private BytesRef prefix;

            PrefixTermsEnum(TermsEnum termEnum, BytesRef prefix) {
                super(termEnum);
                this.prefix = prefix;
                this.setInitialSeekTerm(this.prefix);
            }

            @Override
            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                return StringHelper.startsWith(term, this.prefix) ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        }
    }
}

