/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.kernel.api.impl.index.collector.FirstHitCollector;
import org.neo4j.kernel.api.impl.index.partition.IndexPartition;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.Bitmap;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;

public class PartitionedLuceneLabelScanWriter
implements LabelScanWriter {
    private final Integer MAXIMUM_PARTITION_SIZE = Integer.getInteger("labelScanStore.maxPartitionSize", 0x7FFFFF7F);
    private final BitmapDocumentFormat format;
    private final List<NodeLabelUpdate> updates;
    private long currentRange;
    private LuceneLabelScanIndex index;

    public PartitionedLuceneLabelScanWriter(LuceneLabelScanIndex index, BitmapDocumentFormat format2) {
        this.index = index;
        this.format = format2;
        this.currentRange = -1L;
        this.updates = new ArrayList<NodeLabelUpdate>(format2.bitmapFormat().rangeSize());
    }

    @Override
    public void write(NodeLabelUpdate update2) throws IOException {
        long range2 = this.format.bitmapFormat().rangeOf(update2.getNodeId());
        if (range2 != this.currentRange) {
            if (range2 < this.currentRange) {
                throw new IllegalArgumentException(String.format("NodeLabelUpdates must be supplied in order of ascending node id. Current range:%d, node id of this update:%d", this.currentRange, update2.getNodeId()));
            }
            this.flush();
            this.currentRange = range2;
        }
        this.updates.add(update2);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.index.maybeRefreshBlocking();
    }

    private Map<Long, Bitmap> readLabelBitMapsInRange(IndexSearcher searcher, long range2) throws IOException {
        HashMap<Long, Bitmap> fields = new HashMap<Long, Bitmap>();
        Term documentTerm = this.format.rangeTerm(range2);
        TermQuery query = new TermQuery(documentTerm);
        FirstHitCollector hitCollector = new FirstHitCollector();
        searcher.search((Query)query, hitCollector);
        if (hitCollector.hasMatched()) {
            Document document = searcher.doc(hitCollector.getMatchedDoc());
            for (IndexableField field2 : document.getFields()) {
                if (this.format.isRangeOrLabelField(field2)) continue;
                Long label = Long.valueOf(field2.name());
                fields.put(label, this.format.readBitmap(field2));
            }
        }
        return fields;
    }

    private void flush() throws IOException {
        if (this.currentRange < 0L) {
            return;
        }
        IndexPartition partition2 = this.getCurrentPartition();
        try (PartitionSearcher partitionSearcher = partition2.acquireSearcher();){
            IndexSearcher searcher = partitionSearcher.getIndexSearcher();
            Map<Long, Bitmap> fields = this.readLabelBitMapsInRange(searcher, this.currentRange);
            this.updateFields(this.updates, fields);
            Document document = new Document();
            this.format.addRangeValuesField(document, this.currentRange);
            for (Map.Entry<Long, Bitmap> field2 : fields.entrySet()) {
                Bitmap value = field2.getValue();
                if (!value.hasContent()) continue;
                this.format.addLabelAndSearchFields(document, field2.getKey(), value);
            }
            if (this.isEmpty(document)) {
                partition2.getIndexWriter().deleteDocuments(this.format.rangeTerm(document));
            } else {
                partition2.getIndexWriter().updateDocument(this.format.rangeTerm(document), document);
            }
            this.updates.clear();
        }
    }

    private IndexPartition getCurrentPartition() throws IOException {
        int partition2 = this.getPartitionForRange();
        while (this.isNotEnoughPartitions(partition2)) {
            this.index.addNewPartition();
        }
        return this.index.getPartitions().get(partition2);
    }

    private boolean isNotEnoughPartitions(int partition2) {
        return this.index.getPartitions().size() < partition2 + 1;
    }

    private int getPartitionForRange() {
        return Math.toIntExact(this.currentRange / (long)this.MAXIMUM_PARTITION_SIZE.intValue());
    }

    private boolean isEmpty(Document document) {
        for (IndexableField fieldable : document.getFields()) {
            if (this.format.isRangeOrLabelField(fieldable)) continue;
            return false;
        }
        return true;
    }

    private void updateFields(Iterable<NodeLabelUpdate> updates, Map<Long, Bitmap> fields) {
        for (NodeLabelUpdate update2 : updates) {
            this.clearLabels(fields, update2);
            this.setLabels(fields, update2);
        }
    }

    private void clearLabels(Map<Long, Bitmap> fields, NodeLabelUpdate update2) {
        for (Bitmap bitmap : fields.values()) {
            this.format.bitmapFormat().set(bitmap, update2.getNodeId(), false);
        }
    }

    private void setLabels(Map<Long, Bitmap> fields, NodeLabelUpdate update2) {
        for (long label : update2.getLabelsAfter()) {
            Bitmap bitmap = fields.get(label);
            if (bitmap == null) {
                bitmap = new Bitmap();
                fields.put(label, bitmap);
            }
            this.format.bitmapFormat().set(bitmap, update2.getNodeId(), true);
        }
    }
}

