/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.reader;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.kernel.api.impl.labelscan.LuceneNodeLabelRange;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.Bitmap;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;

public class LuceneAllEntriesLabelScanReader
implements AllEntriesLabelScanReader {
    private final BitmapDocumentFormat format;
    private final BoundedIterable<Document> documents;

    public LuceneAllEntriesLabelScanReader(BoundedIterable<Document> documents, BitmapDocumentFormat format2) {
        this.documents = documents;
        this.format = format2;
    }

    @Override
    public Iterator<NodeLabelRange> iterator() {
        final Iterator iterator2 = this.documents.iterator();
        return new Iterator<NodeLabelRange>(){
            private int id = 0;

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public LuceneNodeLabelRange next() {
                return LuceneAllEntriesLabelScanReader.this.parse(this.id++, (Document)iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @Override
    public void close() throws Exception {
        this.documents.close();
    }

    @Override
    public long maxCount() {
        return this.documents.maxCount();
    }

    private LuceneNodeLabelRange parse(int id, Document document) {
        Bitmap[] bitmaps;
        long[] labelIds;
        List<IndexableField> fields = document.getFields();
        int expectedLabelFields = fields.size() - 1;
        long[] scratchLabelIds = new long[expectedLabelFields];
        Bitmap[] scratchBitmaps = new Bitmap[expectedLabelFields];
        int i = 0;
        long rangeId = -1L;
        for (IndexableField field2 : fields) {
            if (this.format.isRangeField(field2)) {
                rangeId = this.format.rangeOf(field2);
                continue;
            }
            if (!this.format.isLabelBitmapField(field2)) continue;
            scratchLabelIds[i] = this.format.labelId(field2);
            scratchBitmaps[i] = this.format.readBitmap(field2);
            ++i;
        }
        assert (rangeId >= 0L);
        if (i < expectedLabelFields) {
            labelIds = Arrays.copyOf(scratchLabelIds, i);
            bitmaps = Arrays.copyOf(scratchBitmaps, i);
        } else {
            labelIds = scratchLabelIds;
            bitmaps = scratchBitmaps;
        }
        return LuceneNodeLabelRange.fromBitmapStructure(id, labelIds, this.getLongs(bitmaps, rangeId));
    }

    private long[][] getLongs(Bitmap[] bitmaps, long rangeId) {
        long[][] nodeIds = new long[bitmaps.length][];
        for (int k = 0; k < nodeIds.length; ++k) {
            nodeIds[k] = this.format.bitmapFormat().convertRangeAndBitmapToArray(rangeId, bitmaps[k].bitmap());
        }
        return nodeIds;
    }
}

