/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.bitmaps;

import org.neo4j.kernel.api.impl.labelscan.bitmaps.Bitmap;

public enum BitmapFormat {
    _32(5, 0xFFFFFFFFL),
    _64(6, -1L);

    public final int shift;
    private final long mask;

    private BitmapFormat(int shift, long mask) {
        this.shift = shift;
        this.mask = mask;
    }

    public int rangeSize() {
        return 1 << this.shift;
    }

    public long rangeOf(long id) {
        return id >> this.shift;
    }

    public long[] convertRangeAndBitmapToArray(long range2, long bitmap) {
        int bitCount = Long.bitCount(bitmap &= this.mask);
        if (bitCount == 0) {
            return null;
        }
        long[] result2 = new long[bitCount];
        int offset = -1;
        for (int i = 0; i < result2.length; ++i) {
            while ((bitmap & 1L << ++offset) == 0L) {
            }
            result2[i] = range2 << this.shift | (long)offset;
        }
        return result2;
    }

    public boolean hasLabel(long bitmap, long nodeId) {
        long normalizedNodeId = nodeId % (1L << this.shift);
        long bitRepresentingNodeIdInBitmap = 1L << (int)normalizedNodeId;
        return (bitmap & bitRepresentingNodeIdInBitmap) != 0L;
    }

    public void set(Bitmap bitmap, long id, boolean set) {
        if (bitmap == null) {
            return;
        }
        long low = (1L << this.shift) - 1L;
        bitmap.bitmap = set ? (bitmap.bitmap |= 1L << (int)(id & low)) : (bitmap.bitmap &= this.mask ^ 1L << (int)(id & low));
    }
}

