/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.bitmaps;

import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.BitmapFormat;

public class BitmapExtractor
extends PrefetchingIterator<long[]> {
    private final BitmapFormat format;
    private final long[] rangeBitmap;
    private int offset;

    public BitmapExtractor(BitmapFormat format2, long ... rangeBitmap) {
        this.format = format2;
        this.rangeBitmap = rangeBitmap;
    }

    @Override
    protected long[] fetchNextOrNull() {
        while (this.offset < this.rangeBitmap.length) {
            long[] result2 = this.format.convertRangeAndBitmapToArray(this.rangeBitmap[this.offset], this.rangeBitmap[this.offset + 1]);
            this.offset += 2;
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

