/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.LockObtainFailedException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndex;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class LuceneLabelScanStore
implements LabelScanStore {
    private final LuceneLabelScanIndex luceneIndex;
    private final LabelScanStoreProvider.FullStoreChangeStream fullStoreStream;
    private final Log log;
    private final Monitor monitor;
    private boolean needsRebuild;

    public LuceneLabelScanStore(LuceneLabelScanIndex luceneIndex, LabelScanStoreProvider.FullStoreChangeStream fullStoreStream, LogProvider logProvider, Monitor monitor) {
        this.luceneIndex = luceneIndex;
        this.fullStoreStream = fullStoreStream;
        this.log = logProvider.getLog(this.getClass());
        this.monitor = monitor;
    }

    @Override
    public void force() {
        try {
            if (this.luceneIndex.isOpen()) {
                this.luceneIndex.flush();
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public AllEntriesLabelScanReader allNodeLabelRanges() {
        return this.luceneIndex.allNodeLabelRanges();
    }

    @Override
    public LabelScanReader newReader() {
        return this.luceneIndex.getLabelScanReader();
    }

    @Override
    public ResourceIterator<File> snapshotStoreFiles() throws IOException {
        return this.luceneIndex.snapshot();
    }

    @Override
    public void init() throws IOException {
        this.monitor.init();
        try {
            if (!this.luceneIndex.exists()) {
                this.log.info("No lucene scan store index found, this might just be first use. Preparing to rebuild.");
                this.monitor.noIndex();
                this.luceneIndex.create();
                this.needsRebuild = true;
            } else if (!this.luceneIndex.isValid()) {
                this.log.warn("Lucene scan store index could not be read. Preparing to rebuild.");
                this.monitor.corruptedIndex();
                this.luceneIndex.drop();
                this.luceneIndex.create();
                this.needsRebuild = true;
            }
            this.luceneIndex.open();
        }
        catch (LockObtainFailedException e) {
            this.luceneIndex.close();
            this.log.error("Index is locked by another process or database", e);
            this.monitor.lockedIndex(e);
            throw e;
        }
    }

    @Override
    public void start() throws IOException {
        if (this.needsRebuild) {
            this.monitor.rebuilding();
            this.log.info("Rebuilding lucene scan store, this may take a while");
            long numberOfNodes = this.rebuild();
            this.monitor.rebuilt(numberOfNodes);
            this.log.info("Lucene scan store rebuilt (roughly " + numberOfNodes + " nodes)");
            this.needsRebuild = false;
        }
    }

    private long rebuild() throws IOException {
        try (LabelScanWriter writer = this.newWriter();){
            long l = this.fullStoreStream.applyTo(writer);
            return l;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() throws IOException {
        this.luceneIndex.close();
    }

    @Override
    public LabelScanWriter newWriter() {
        return this.luceneIndex.getLabelScanWriter();
    }

    public static interface Monitor {
        public static final Monitor EMPTY = new Monitor(){

            @Override
            public void init() {
            }

            @Override
            public void noIndex() {
            }

            @Override
            public void lockedIndex(LockObtainFailedException e) {
            }

            @Override
            public void corruptedIndex() {
            }

            @Override
            public void rebuilding() {
            }

            @Override
            public void rebuilt(long roughNodeCount) {
            }
        };

        public void init();

        public void noIndex();

        public void lockedIndex(LockObtainFailedException var1);

        public void corruptedIndex();

        public void rebuilding();

        public void rebuilt(long var1);
    }
}

