/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.partition.IndexPartition;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.labelscan.reader.PartitionedLuceneLabelScanStoreReader;
import org.neo4j.kernel.api.impl.labelscan.reader.SimpleLuceneLabelScanStoreReader;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.LabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.NodeRangeDocumentLabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.labelscan.writer.PartitionedLuceneLabelScanWriter;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class LuceneLabelScanIndex
extends AbstractLuceneIndex {
    private final BitmapDocumentFormat format;
    private final LabelScanStorageStrategy storageStrategy;

    public LuceneLabelScanIndex(BitmapDocumentFormat format2, PartitionedIndexStorage indexStorage) {
        super(indexStorage, IndexWriterConfigs::standard);
        this.format = format2;
        this.storageStrategy = new NodeRangeDocumentLabelScanStorageStrategy(format2);
    }

    public LabelScanReader getLabelScanReader() {
        this.ensureOpen();
        this.partitionsLock.lock();
        try {
            List<IndexPartition> partitions = this.getPartitions();
            LabelScanReader labelScanReader = this.hasSinglePartition(partitions) ? this.createSimpleReader(partitions) : this.createPartitionedReader(partitions);
            return labelScanReader;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.partitionsLock.unlock();
        }
    }

    public LabelScanWriter getLabelScanWriter() {
        this.ensureOpen();
        return new PartitionedLuceneLabelScanWriter(this, this.format);
    }

    public AllEntriesLabelScanReader allNodeLabelRanges() {
        return this.storageStrategy.newNodeLabelReader(this.allDocumentsReader());
    }

    private LabelScanReader createSimpleReader(List<IndexPartition> partitions) throws IOException {
        IndexPartition partition2 = this.getFirstPartition(partitions);
        PartitionSearcher searcher = partition2.acquireSearcher();
        return new SimpleLuceneLabelScanStoreReader(searcher, this.storageStrategy);
    }

    private LabelScanReader createPartitionedReader(List<IndexPartition> partitions) throws IOException {
        List<PartitionSearcher> searchers = LuceneLabelScanIndex.acquireSearchers(partitions);
        return new PartitionedLuceneLabelScanStoreReader(searchers, this.storageStrategy);
    }
}

