/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.partition;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.backup.LuceneIndexSnapshotFileIterator;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;

public class IndexPartition
implements Closeable {
    private final IndexWriter indexWriter;
    private final Directory directory;
    private final SearcherManager searcherManager;
    private final File indexFolder;

    public IndexPartition(File partitionFolder, Directory directory, IndexWriterConfig writerConfig) throws IOException {
        this.indexFolder = partitionFolder;
        this.directory = directory;
        this.indexWriter = new IndexWriter(directory, writerConfig);
        this.searcherManager = new SearcherManager(this.indexWriter, new SearcherFactory());
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public PartitionSearcher acquireSearcher() throws IOException {
        return new PartitionSearcher(this.searcherManager);
    }

    public void maybeRefreshBlocking() throws IOException {
        this.searcherManager.maybeRefreshBlocking();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.searcherManager, this.indexWriter, this.directory});
    }

    public ResourceIterator<File> snapshot() throws IOException {
        return LuceneIndexSnapshotFileIterator.forIndex(this.indexFolder, this.indexWriter);
    }
}

