/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.collector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.impl.lucene.legacy.AbstractIndexHits;
import org.neo4j.index.impl.lucene.legacy.EmptyIndexHits;
import org.neo4j.kernel.api.impl.index.collector.DocValuesAccess;

public class DocValuesCollector
extends SimpleCollector {
    private static final EmptyIndexHits<Document> EMPTY_INDEX_HITS = new EmptyIndexHits();
    private LeafReaderContext context;
    private int segmentHits;
    private int totalHits;
    private Scorer scorer;
    private float[] scores;
    private final boolean keepScores;
    private final List<MatchingDocs> matchingDocs = new ArrayList<MatchingDocs>();
    private Docs docs;

    public DocValuesCollector() {
        this(false);
    }

    public DocValuesCollector(boolean keepScores) {
        this.keepScores = keepScores;
    }

    public LongValuesIterator getValuesIterator(String field2) {
        return new LongValuesIterator(this.getMatchingDocs(), this.getTotalHits(), field2);
    }

    public PrimitiveLongIterator getSortedValuesIterator(String field2, Sort sort) throws IOException {
        if (sort == null || sort == Sort.INDEXORDER) {
            return this.getValuesIterator(field2);
        }
        int size2 = this.getTotalHits();
        if (size2 == 0) {
            return PrimitiveLongCollections.emptyIterator();
        }
        TopDocs topDocs = this.getTopDocs(sort, size2);
        LeafReaderContext[] contexts = DocValuesCollector.getLeafReaderContexts(this.getMatchingDocs());
        return new TopDocsValuesIterator(topDocs, contexts, field2);
    }

    public IndexHits<Document> getIndexHits(Sort sort) throws IOException {
        List<MatchingDocs> matchingDocs = this.getMatchingDocs();
        int size2 = this.getTotalHits();
        if (size2 == 0) {
            return EMPTY_INDEX_HITS;
        }
        if (sort == null || sort == Sort.INDEXORDER) {
            return new DocsInIndexOrderIterator(matchingDocs, size2, this.isKeepScores());
        }
        TopDocs topDocs = this.getTopDocs(sort, size2);
        LeafReaderContext[] contexts = DocValuesCollector.getLeafReaderContexts(matchingDocs);
        return new TopDocsIterator(topDocs, contexts);
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public boolean isKeepScores() {
        return this.keepScores;
    }

    @Override
    public final void collect(int doc2) throws IOException {
        this.docs.addDoc(doc2);
        if (this.keepScores) {
            if (this.segmentHits >= this.scores.length) {
                float[] newScores = new float[ArrayUtil.oversize(this.segmentHits + 1, 4)];
                System.arraycopy(this.scores, 0, newScores, 0, this.segmentHits);
                this.scores = newScores;
            }
            this.scores[this.segmentHits] = this.scorer.score();
        }
        ++this.segmentHits;
        ++this.totalHits;
    }

    @Override
    public boolean needsScores() {
        return this.keepScores;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        if (this.docs != null && this.segmentHits > 0) {
            this.createMatchingDocs();
        }
        int maxDoc = context.reader().maxDoc();
        this.docs = this.createDocs(maxDoc);
        if (this.keepScores) {
            int initialSize = Math.min(32, maxDoc);
            this.scores = new float[initialSize];
        }
        this.segmentHits = 0;
        this.context = context;
    }

    public List<MatchingDocs> getMatchingDocs() {
        if (this.docs != null && this.segmentHits > 0) {
            this.createMatchingDocs();
            this.docs = null;
            this.scores = null;
            this.context = null;
        }
        return Collections.unmodifiableList(this.matchingDocs);
    }

    private Docs createDocs(int maxDoc) {
        return new Docs(maxDoc);
    }

    private void createMatchingDocs() {
        if (this.scores == null || this.scores.length == this.segmentHits) {
            this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.segmentHits, this.scores));
        } else {
            float[] finalScores = new float[this.segmentHits];
            System.arraycopy(this.scores, 0, finalScores, 0, this.segmentHits);
            this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.segmentHits, finalScores));
        }
    }

    private TopDocs getTopDocs(Sort sort, int size2) throws IOException {
        TopDocs topDocs;
        if (sort == Sort.RELEVANCE) {
            TopScoreDocCollector collector = TopScoreDocCollector.create(size2);
            this.replayTo(collector);
            topDocs = collector.topDocs();
        } else {
            TopFieldCollector collector = TopFieldCollector.create(sort, size2, false, true, false);
            this.replayTo(collector);
            topDocs = collector.topDocs();
        }
        return topDocs;
    }

    private static LeafReaderContext[] getLeafReaderContexts(List<MatchingDocs> matchingDocs) {
        int segments2 = matchingDocs.size();
        LeafReaderContext[] contexts = new LeafReaderContext[segments2];
        for (int i = 0; i < segments2; ++i) {
            MatchingDocs matchingDoc = matchingDocs.get(i);
            contexts[i] = matchingDoc.context;
        }
        return contexts;
    }

    private void replayTo(Collector collector) throws IOException {
        for (MatchingDocs docs : this.getMatchingDocs()) {
            int doc2;
            LeafCollector leafCollector = collector.getLeafCollector(docs.context);
            DocIdSetIterator idIterator = docs.docIdSet.iterator();
            Scorer scorer = this.isKeepScores() ? new ReplayingScorer(docs.scores) : new ConstantScoreScorer(null, Float.NaN, idIterator);
            leafCollector.setScorer(scorer);
            while ((doc2 = idIterator.nextDoc()) != Integer.MAX_VALUE) {
                leafCollector.collect(doc2);
            }
        }
    }

    private static final class TopDocsValuesIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
        private final ScoreDocsIterator scoreDocs;
        private final String field;
        private Map<LeafReaderContext, NumericDocValues> docValuesCache;
        private long currentValue;

        public TopDocsValuesIterator(TopDocs docs, LeafReaderContext[] contexts, String field2) {
            this.field = field2;
            this.docValuesCache = new HashMap<LeafReaderContext, NumericDocValues>(contexts.length);
            this.scoreDocs = new ScoreDocsIterator(docs, contexts){

                @Override
                protected void onNextDoc(int localDocID, LeafReaderContext context) {
                    this.loadNextValue(context, localDocID);
                }
            };
        }

        @Override
        protected boolean fetchNext() {
            if (this.scoreDocs.hasNext()) {
                this.scoreDocs.next();
                return this.currentValue != -1L && this.next(this.currentValue);
            }
            return false;
        }

        private void loadNextValue(LeafReaderContext context, int docID) {
            NumericDocValues docValues;
            if (this.docValuesCache.containsKey(context)) {
                docValues = this.docValuesCache.get(context);
            } else {
                try {
                    docValues = context.reader().getNumericDocValues(this.field);
                    this.docValuesCache.put(context, docValues);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.currentValue = docValues != null ? docValues.get(docID) : -1L;
        }
    }

    private static final class TopDocsIterator
    extends AbstractIndexHits<Document> {
        private final int size;
        private final ScoreDocsIterator scoreDocs;
        private Document currentDoc;

        private TopDocsIterator(TopDocs docs, LeafReaderContext[] contexts) {
            this.scoreDocs = new ScoreDocsIterator(docs, contexts){

                @Override
                protected void onNextDoc(int localDocID, LeafReaderContext context) {
                    this.updateCurrentDocument(localDocID, context.reader());
                }
            };
            this.size = docs.scoreDocs.length;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public float currentScore() {
            return this.scoreDocs.getCurrentDoc().score;
        }

        @Override
        protected Document fetchNextOrNull() {
            if (!this.scoreDocs.hasNext()) {
                return null;
            }
            this.scoreDocs.next();
            return this.currentDoc;
        }

        private void updateCurrentDocument(int docID, LeafReader reader) {
            try {
                this.currentDoc = reader.document(docID);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class ScoreDocsIterator
    extends PrefetchingIterator<ScoreDoc> {
        private final Iterator<ScoreDoc> iterator;
        private final int[] docStarts;
        private final LeafReaderContext[] contexts;
        protected ScoreDoc currentDoc;

        private ScoreDocsIterator(TopDocs docs, LeafReaderContext[] contexts) {
            this.contexts = contexts;
            this.iterator = new ArrayIterator<ScoreDoc>(docs.scoreDocs);
            int segments2 = contexts.length;
            this.docStarts = new int[segments2 + 1];
            for (int i = 0; i < segments2; ++i) {
                LeafReaderContext context = contexts[i];
                this.docStarts[i] = context.docBase;
            }
            LeafReaderContext lastContext = contexts[segments2 - 1];
            this.docStarts[segments2] = lastContext.docBase + lastContext.reader().maxDoc();
        }

        public ScoreDoc getCurrentDoc() {
            return this.currentDoc;
        }

        @Override
        protected ScoreDoc fetchNextOrNull() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            this.currentDoc = this.iterator.next();
            int subIndex = ReaderUtil.subIndex(this.currentDoc.doc, this.docStarts);
            LeafReaderContext context = this.contexts[subIndex];
            this.onNextDoc(this.currentDoc.doc - context.docBase, context);
            return this.currentDoc;
        }

        protected abstract void onNextDoc(int var1, LeafReaderContext var2);
    }

    private static final class DocsInIndexOrderIterator
    extends AbstractIndexHits<Document> {
        private final Iterator<MatchingDocs> docs;
        private final int size;
        private final boolean keepScores;
        private DocIdSetIterator currentIdIterator;
        private Scorer currentScorer;
        private LeafReader currentReader;

        private DocsInIndexOrderIterator(List<MatchingDocs> docs, int size2, boolean keepScores) {
            this.size = size2;
            this.keepScores = keepScores;
            this.docs = docs.iterator();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public float currentScore() {
            try {
                return this.currentScorer.score();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected Document fetchNextOrNull() {
            if (this.ensureValidDisi()) {
                try {
                    int doc2 = this.currentIdIterator.nextDoc();
                    if (doc2 == Integer.MAX_VALUE) {
                        this.currentIdIterator = null;
                        this.currentScorer = null;
                        this.currentReader = null;
                        return this.fetchNextOrNull();
                    }
                    return this.currentReader.document(doc2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        private boolean ensureValidDisi() {
            while (this.currentIdIterator == null && this.docs.hasNext()) {
                MatchingDocs matchingDocs = this.docs.next();
                try {
                    this.currentIdIterator = matchingDocs.docIdSet.iterator();
                    this.currentScorer = this.keepScores ? new ReplayingScorer(matchingDocs.scores) : new ConstantScoreScorer(null, Float.NaN, this.currentIdIterator);
                    this.currentReader = matchingDocs.context.reader();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.currentIdIterator != null;
        }
    }

    private static class ReplayingScorer
    extends Scorer {
        private final float[] scores;
        private int index = 0;

        public ReplayingScorer(float[] scores) {
            super(null);
            this.scores = scores;
        }

        @Override
        public float score() throws IOException {
            if (this.index < this.scores.length) {
                return this.scores[this.index++];
            }
            return Float.NaN;
        }

        @Override
        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docID() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Docs {
        private final DocIdSetBuilder bits;

        public Docs(int maxDoc) {
            this.bits = new DocIdSetBuilder(maxDoc);
        }

        public void addDoc(int docId) {
            this.bits.add(docId);
        }

        public DocIdSet getDocIdSet() {
            return this.bits.build();
        }
    }

    static final class MatchingDocs {
        public final LeafReaderContext context;
        public final DocIdSet docIdSet;
        public final float[] scores;
        public final int totalHits;

        public MatchingDocs(LeafReaderContext context, DocIdSet docIdSet, int totalHits, float[] scores) {
            this.context = context;
            this.docIdSet = docIdSet;
            this.totalHits = totalHits;
            this.scores = scores;
        }

        public NumericDocValues readDocValues(String field2) {
            try {
                NumericDocValues dv = this.context.reader().getNumericDocValues(field2);
                if (dv == null) {
                    FieldInfo fi = this.context.reader().getFieldInfos().fieldInfo(field2);
                    DocValuesType actual2 = null;
                    if (fi != null) {
                        actual2 = fi.getDocValuesType();
                    }
                    throw new IllegalStateException("The field '" + field2 + "' is not indexed properly, expected NumericDV, but got '" + (Object)((Object)actual2) + "'");
                }
                return dv;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class LongValuesIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator
    implements DocValuesAccess {
        private final Iterator<MatchingDocs> matchingDocs;
        private final String field;
        private final int size;
        private DocIdSetIterator currentIdIterator;
        private NumericDocValues currentDocValues;
        private MatchingDocs currentDocs;
        private final Map<String, NumericDocValues> docValuesCache;
        private int index = 0;

        public LongValuesIterator(Iterable<MatchingDocs> allMatchingDocs, int totalHits, String field2) {
            this.size = totalHits;
            this.field = field2;
            this.matchingDocs = allMatchingDocs.iterator();
            this.docValuesCache = new HashMap<String, NumericDocValues>();
        }

        public int remaining() {
            return this.size - this.index;
        }

        @Override
        public long current() {
            return this.next;
        }

        @Override
        public long getValue(String field2) {
            if (this.ensureValidDisi()) {
                if (this.docValuesCache.containsKey(field2)) {
                    return this.docValuesCache.get(field2).get(this.currentIdIterator.docID());
                }
                NumericDocValues docValues = this.currentDocs.readDocValues(field2);
                this.docValuesCache.put(field2, docValues);
                return docValues.get(this.currentIdIterator.docID());
            }
            return 0L;
        }

        @Override
        protected boolean fetchNext() {
            try {
                if (this.ensureValidDisi()) {
                    int nextDoc = this.currentIdIterator.nextDoc();
                    if (nextDoc != Integer.MAX_VALUE) {
                        ++this.index;
                        return this.next(this.currentDocValues.get(nextDoc));
                    }
                    this.currentIdIterator = null;
                    return this.fetchNext();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        private boolean ensureValidDisi() {
            try {
                while (this.currentIdIterator == null) {
                    if (this.matchingDocs.hasNext()) {
                        this.currentDocs = this.matchingDocs.next();
                        this.currentIdIterator = this.currentDocs.docIdSet.iterator();
                        if (this.currentIdIterator == null) continue;
                        this.docValuesCache.clear();
                        this.currentDocValues = this.currentDocs.readDocValues(this.field);
                        continue;
                    }
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

