/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.LucenePartitionAllDocumentsReader;

public class LuceneAllDocumentsReader
implements BoundedIterable<Document> {
    private final List<LucenePartitionAllDocumentsReader> partitionReaders;

    public LuceneAllDocumentsReader(List<LucenePartitionAllDocumentsReader> partitionReaders) {
        this.partitionReaders = partitionReaders;
    }

    @Override
    public long maxCount() {
        return this.partitionReaders.stream().mapToLong(LucenePartitionAllDocumentsReader::maxCount).sum();
    }

    @Override
    public Iterator<Document> iterator() {
        Iterator iterators = this.partitionReaders.stream().map(LucenePartitionAllDocumentsReader::iterator).collect(Collectors.toList()).iterator();
        return Iterators.concat(iterators);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll(this.partitionReaders);
    }
}

