/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.blocktreeords.BlockTreeOrdsPostingsFormat;
import org.apache.lucene.codecs.lucene54.Lucene54Codec;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.MultipleBackupDeletionPolicy;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public final class IndexWriterConfigs {
    private static final int MAX_BUFFERED_DOCS = FeatureToggles.getInteger(IndexWriterConfigs.class, "max_buffered_docs", 100000);
    private static final int MERGE_POLICY_MERGE_FACTOR = FeatureToggles.getInteger(IndexWriterConfigs.class, "merge.factor", 2);
    private static final double MERGE_POLICY_NO_CFS_RATIO = FeatureToggles.getDouble(IndexWriterConfigs.class, "nocfs.ratio", 1.0);
    private static final double MERGE_POLICY_MIN_MERGE_MB = FeatureToggles.getDouble(IndexWriterConfigs.class, "min.merge", 0.1);
    private static final boolean CODEC_BLOCK_TREE_ORDS_POSTING_FORMAT = FeatureToggles.flag(IndexWriterConfigs.class, "block.tree.ords.posting.format", true);
    private static final int POPULATION_RAM_BUFFER_SIZE_MB = FeatureToggles.getInteger(IndexWriterConfigs.class, "population.ram.buffer.size", 50);
    private static final BlockTreeOrdsPostingsFormat blockTreeOrdsPostingsFormat = new BlockTreeOrdsPostingsFormat();

    private IndexWriterConfigs() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static IndexWriterConfig standard() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(LuceneDataSource.KEYWORD_ANALYZER);
        writerConfig.setMaxBufferedDocs(MAX_BUFFERED_DOCS);
        writerConfig.setIndexDeletionPolicy(new MultipleBackupDeletionPolicy());
        writerConfig.setUseCompoundFile(true);
        writerConfig.setCodec(new Lucene54Codec(){

            @Override
            public PostingsFormat getPostingsFormatForField(String field2) {
                PostingsFormat postingFormat = super.getPostingsFormatForField(field2);
                return CODEC_BLOCK_TREE_ORDS_POSTING_FORMAT ? blockTreeOrdsPostingsFormat : postingFormat;
            }
        });
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setNoCFSRatio(MERGE_POLICY_NO_CFS_RATIO);
        mergePolicy.setMinMergeMB(MERGE_POLICY_MIN_MERGE_MB);
        mergePolicy.setMergeFactor(MERGE_POLICY_MERGE_FACTOR);
        writerConfig.setMergePolicy(mergePolicy);
        return writerConfig;
    }

    public static IndexWriterConfig population() {
        IndexWriterConfig writerConfig = IndexWriterConfigs.standard();
        writerConfig.setMaxBufferedDocs(-1);
        writerConfig.setRAMBufferSizeMB(POPULATION_RAM_BUFFER_SIZE_MB);
        return writerConfig;
    }
}

