/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;

public class IndexBelongsToConstraintException
extends SchemaKernelException {
    private final IndexDescriptor index;
    private static final String message = "Index belongs to constraint: %s";

    public IndexBelongsToConstraintException(IndexDescriptor index) {
        super(Status.Schema.ForbiddenOnConstraintIndex, String.format(message, index));
        this.index = index;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(message, this.index.userDescription(tokenNameLookup));
    }
}

