/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import java.util.Arrays;

public abstract class IndexEntryConflictException
extends Exception {
    public IndexEntryConflictException(String message) {
        super(message);
    }

    protected static String quote(Object propertyValue) {
        if (propertyValue instanceof String) {
            return String.format("'%s'", propertyValue);
        }
        if (propertyValue.getClass().isArray()) {
            Class<?> type = propertyValue.getClass().getComponentType();
            if (type == Boolean.TYPE) {
                return Arrays.toString((boolean[])propertyValue);
            }
            if (type == Byte.TYPE) {
                return Arrays.toString((byte[])propertyValue);
            }
            if (type == Short.TYPE) {
                return Arrays.toString((short[])propertyValue);
            }
            if (type == Character.TYPE) {
                return Arrays.toString((char[])propertyValue);
            }
            if (type == Integer.TYPE) {
                return Arrays.toString((int[])propertyValue);
            }
            if (type == Long.TYPE) {
                return Arrays.toString((long[])propertyValue);
            }
            if (type == Float.TYPE) {
                return Arrays.toString((float[])propertyValue);
            }
            if (type == Double.TYPE) {
                return Arrays.toString((double[])propertyValue);
            }
            return Arrays.toString((Object[])propertyValue);
        }
        return String.valueOf(propertyValue);
    }

    public RuntimeException notAllowed(int labelId, int propertyKeyId) {
        return new IllegalStateException(String.format("Index for label:%s propertyKey:%s should not require unique values.", labelId, propertyKeyId), this);
    }

    public abstract Object getPropertyValue();

    public abstract String evidenceMessage(String var1, String var2);
}

