/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class SequenceLock {
    private static final long CNT_BITS = 17L;
    private static final long BITS_IN_LONG = 64L;
    private static final long EXL_LOCK_BITS = 1L;
    private static final long FLS_LOCK_BITS = 1L;
    private static final long SEQ_BITS = 45L;
    private static final long CNT_UNIT = 0x200000000000L;
    private static final long SEQ_MASK = 0x1FFFFFFFFFFFL;
    private static final long SEQ_IMSK = -35184372088832L;
    private static final long CNT_MASK = 4611650834055299072L;
    private static final long EXL_MASK = 0x4000000000000000L;
    private static final long FLS_MASK = Long.MIN_VALUE;
    private static final long FLS_IMSK = Long.MAX_VALUE;
    private static final long FAE_MASK = -4611686018427387904L;
    private static final long UNL_MASK = -35184372088832L;
    private static final long STATE = UnsafeUtil.getFieldOffset(SequenceLock.class, "state");
    private volatile long state;

    private long getState() {
        return this.state;
    }

    private boolean compareAndSetState(long expect, long update2) {
        return UnsafeUtil.compareAndSwapLong(this, STATE, expect, update2);
    }

    private void unconditionallySetState(long update2) {
        this.state = update2;
    }

    public long tryOptimisticReadLock() {
        return this.getState() & 0x1FFFFFFFFFFFL;
    }

    public boolean validateReadLock(long stamp) {
        UnsafeUtil.loadFence();
        return (this.getState() & Long.MAX_VALUE) == stamp;
    }

    public boolean tryWriteLock() {
        long n;
        long s2;
        do {
            boolean writeCountOverflow;
            boolean unwritablyLocked = ((s2 = this.getState()) & 0x4000000000000000L) != 0L;
            boolean bl = writeCountOverflow = (s2 & 0x3FFFE00000000000L) == 4611650834055299072L;
            if (!(unwritablyLocked | writeCountOverflow)) continue;
            return this.failWriteLock(s2, writeCountOverflow);
        } while (!this.compareAndSetState(s2, n = s2 + 0x200000000000L));
        UnsafeUtil.storeFence();
        return true;
    }

    private boolean failWriteLock(long s2, boolean writeCountOverflow) {
        if (writeCountOverflow) {
            this.throwWriteLockOverflow(s2);
        }
        return false;
    }

    private long throwWriteLockOverflow(long s2) {
        throw new IllegalMonitorStateException("Write lock counter overflow: " + this.describeState(s2));
    }

    public void unlockWrite() {
        long n;
        long s2;
        do {
            if (((s2 = this.getState()) & 0x3FFFE00000000000L) != 0L) continue;
            this.throwUnmatchedUnlockWrite(s2);
        } while (!this.compareAndSetState(s2, n = this.nextSeq(s2) - 0x200000000000L));
    }

    private void throwUnmatchedUnlockWrite(long s2) {
        throw new IllegalMonitorStateException("Unmatched unlockWrite: " + this.describeState(s2));
    }

    private long nextSeq(long s2) {
        return (s2 & 0xFFFFE00000000000L) + (s2 + 1L & 0x1FFFFFFFFFFFL);
    }

    public boolean tryExclusiveLock() {
        long s2 = this.getState();
        boolean res = (s2 & 0xFFFFE00000000000L) == 0L && this.compareAndSetState(s2, s2 + 0x4000000000000000L);
        UnsafeUtil.storeFence();
        return res;
    }

    public long unlockExclusive() {
        long s2 = this.initiateExclusiveLockRelease();
        long n = this.nextSeq(s2) - 0x4000000000000000L;
        this.unconditionallySetState(n);
        return n;
    }

    public void unlockExclusiveAndTakeWriteLock() {
        long s2 = this.initiateExclusiveLockRelease();
        long n = this.nextSeq(s2) - 0x4000000000000000L + 0x200000000000L;
        this.unconditionallySetState(n);
    }

    private long initiateExclusiveLockRelease() {
        long s2 = this.getState();
        if ((s2 & 0x4000000000000000L) != 0x4000000000000000L) {
            this.throwUnmatchedUnlockExclusive(s2);
        }
        return s2;
    }

    private void throwUnmatchedUnlockExclusive(long s2) {
        throw new IllegalMonitorStateException("Unmatched unlockExclusive: " + this.describeState(s2));
    }

    public boolean tryFlushLock() {
        long s2 = this.getState();
        boolean res = (s2 & 0xC000000000000000L) == 0L && this.compareAndSetState(s2, s2 + Long.MIN_VALUE);
        UnsafeUtil.storeFence();
        return res;
    }

    public void unlockFlush() {
        long n;
        long s2;
        do {
            if (((s2 = this.getState()) & Long.MIN_VALUE) == Long.MIN_VALUE) continue;
            this.throwUnmatchedUnlockFlush(s2);
        } while (!this.compareAndSetState(s2, n = s2 - Long.MIN_VALUE));
    }

    private void throwUnmatchedUnlockFlush(long s2) {
        throw new IllegalMonitorStateException("Unmatched unlockFlush: " + this.describeState(s2));
    }

    public String toString() {
        long s2 = this.getState();
        return this.describeState(s2);
    }

    private String describeState(long s2) {
        long flush2 = s2 >>> 63;
        long excl = (s2 & 0x4000000000000000L) >>> 62;
        long cnt = (s2 & 0x3FFFE00000000000L) >> 45;
        long seq = s2 & 0x1FFFFFFFFFFFL;
        return "SequenceLock[Flush: " + flush2 + ", Excl: " + excl + ", Ws: " + cnt + ", S: " + seq + ']';
    }
}

