/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.CursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;

final class MuninnReadPageCursor
extends MuninnPageCursor {
    private final CursorPool.CursorSets cursorSets;
    private long lockStamp;
    MuninnReadPageCursor nextCursor;

    MuninnReadPageCursor(CursorPool.CursorSets cursorSets, long victimPage) {
        super(victimPage);
        this.cursorSets = cursorSets;
    }

    @Override
    protected void unpinCurrentPage() {
        MuninnPage p = this.page;
        if (p != null) {
            this.pinEvent.done();
        }
        this.lockStamp = 0L;
        this.clearPageState();
    }

    @Override
    public boolean next() throws IOException {
        this.unpinCurrentPage();
        long lastPageId = this.assertPagedFileStillMappedAndGetIdOfLastPage();
        if (this.nextPageId > lastPageId | this.nextPageId < 0L) {
            return false;
        }
        this.pin(this.nextPageId, false);
        this.currentPageId = this.nextPageId++;
        return true;
    }

    @Override
    protected boolean tryLockPage(MuninnPage page2) {
        this.lockStamp = page2.tryOptimisticReadLock();
        return true;
    }

    @Override
    protected void unlockPage(MuninnPage page2) {
    }

    @Override
    protected void pinCursorToPage(MuninnPage page2, long filePageId, PageSwapper swapper) {
        this.reset(page2);
        page2.incrementUsage();
    }

    @Override
    protected void convertPageFaultLock(MuninnPage page2) {
        this.lockStamp = page2.unlockExclusive();
    }

    @Override
    protected void releaseCursor() {
        this.nextCursor = this.cursorSets.readCursors;
        this.cursorSets.readCursors = this;
    }

    @Override
    public boolean shouldRetry() throws IOException {
        MuninnPage p = this.page;
        boolean needsRetry = p != null && !p.validateReadLock(this.lockStamp);
        if (needsRetry |= this.linkedCursor != null && this.linkedCursor.shouldRetry()) {
            this.startRetry();
        }
        return needsRetry;
    }

    private void startRetry() throws IOException {
        this.setOffset(0);
        this.checkAndClearBoundsFlag();
        this.clearCursorException();
        this.lockStamp = this.page.tryOptimisticReadLock();
        if (!this.page.isBoundTo(this.pagedFile.swapper, this.currentPageId)) {
            this.page = null;
            this.pin(this.currentPageId, false);
        }
    }

    @Override
    public void putByte(byte value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putLong(long value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putInt(int value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length2) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putShort(short value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }
}

