/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.CursorExceptionWithPreciseStackTrace;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnWritePageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

abstract class MuninnPageCursor
extends PageCursor {
    private static final boolean tracePinnedCachePageId = FeatureToggles.flag(MuninnPageCursor.class, "tracePinnedCachePageId", false);
    private static final boolean usePreciseCursorErrorStackTraces = FeatureToggles.flag(MuninnPageCursor.class, "usePreciseCursorErrorStackTraces", false);
    private static final boolean boundsCheck = FeatureToggles.flag(MuninnPageCursor.class, "boundsCheck", true);
    private static final int SIZE_OF_BYTE = 1;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    private final long victimPage;
    protected MuninnPagedFile pagedFile;
    protected PageSwapper swapper;
    protected PageCacheTracer tracer;
    protected MuninnPage page;
    protected PinEvent pinEvent;
    protected long pageId;
    protected int pf_flags;
    protected long currentPageId;
    protected long nextPageId;
    protected MuninnPageCursor linkedCursor;
    private long pointer;
    private int pageSize;
    private int filePageSize;
    private int offset;
    private boolean outOfBounds;
    private Object cursorException;

    MuninnPageCursor(long victimPage) {
        this.victimPage = victimPage;
        this.pointer = victimPage;
    }

    final void initialiseFile(MuninnPagedFile pagedFile) {
        this.swapper = pagedFile.swapper;
        this.tracer = pagedFile.tracer;
    }

    final void initialiseFlags(MuninnPagedFile pagedFile, long pageId, int pf_flags) {
        this.pagedFile = pagedFile;
        this.pageId = pageId;
        this.pf_flags = pf_flags;
        this.filePageSize = pagedFile.filePageSize;
    }

    @Override
    public final void rewind() {
        this.nextPageId = this.pageId;
        this.currentPageId = -1L;
    }

    public final void reset(MuninnPage page2) {
        this.page = page2;
        this.offset = 0;
        this.pointer = page2.address();
        this.pageSize = this.filePageSize;
        if (tracePinnedCachePageId) {
            this.pinEvent.setCachePageId(page2.getCachePageId());
        }
    }

    @Override
    public final boolean next(long pageId) throws IOException {
        if (this.currentPageId == pageId) {
            return true;
        }
        this.nextPageId = pageId;
        return this.next();
    }

    @Override
    public final void close() {
        MuninnPageCursor cursor = this;
        do {
            cursor.unpinCurrentPage();
            cursor.releaseCursor();
            cursor.pagedFile = null;
        } while ((cursor = cursor.getAndClearLinkedCursor()) != null);
    }

    private MuninnPageCursor getAndClearLinkedCursor() {
        MuninnPageCursor cursor = this.linkedCursor;
        this.linkedCursor = null;
        return cursor;
    }

    private void closeLinkedCursorIfAny() {
        if (this.linkedCursor != null) {
            this.linkedCursor.close();
            this.linkedCursor = null;
        }
    }

    @Override
    public PageCursor openLinkedCursor(long pageId) {
        this.closeLinkedCursorIfAny();
        MuninnPagedFile pf = this.pagedFile;
        if (pf == null) {
            throw new IllegalStateException("Cannot open linked cursor on closed page cursor");
        }
        this.linkedCursor = (MuninnPageCursor)pf.io(pageId, this.pf_flags);
        return this.linkedCursor;
    }

    void clearPageState() {
        this.pointer = this.victimPage;
        this.pageSize = 0;
        this.page = null;
        this.currentPageId = -1L;
        this.cursorException = null;
    }

    @Override
    public final long getCurrentPageId() {
        return this.currentPageId;
    }

    @Override
    public final int getCurrentPageSize() {
        return this.currentPageId == -1L ? -1 : this.pagedFile.pageSize();
    }

    @Override
    public final File getCurrentFile() {
        return this.currentPageId == -1L ? null : this.pagedFile.file();
    }

    protected void pin(long filePageId, boolean writeLock) throws IOException {
        Object item;
        this.pinEvent = this.tracer.beginPin(writeLock, filePageId, this.swapper);
        int chunkId = MuninnPagedFile.computeChunkId(filePageId);
        long chunkOffset = MuninnPagedFile.computeChunkOffset(filePageId);
        Object[][] tt = this.pagedFile.translationTable;
        if (tt.length <= chunkId) {
            tt = this.expandTranslationTableCapacity(chunkId);
        }
        Object[] chunk = tt[chunkId];
        do {
            if ((item = UnsafeUtil.getObjectVolatile(chunk, chunkOffset)) != null && item.getClass() == MuninnPage.class) {
                MuninnPage page2 = (MuninnPage)item;
                boolean locked = this.tryLockPage(page2);
                if (locked & page2.isBoundTo(this.swapper, filePageId)) {
                    this.pinCursorToPage(page2, filePageId, this.swapper);
                    return;
                }
                if (locked) {
                    this.unlockPage(page2);
                }
                item = null;
                continue;
            }
            item = this.uncommonPin(item, filePageId, chunkOffset, chunk);
        } while (item == null);
        this.pinCursorToPage((MuninnPage)item, filePageId, this.swapper);
    }

    private Object[][] expandTranslationTableCapacity(int chunkId) {
        return this.pagedFile.expandCapacity(chunkId);
    }

    private Object uncommonPin(Object item, long filePageId, long chunkOffset, Object[] chunk) throws IOException {
        item = item == null ? this.initiatePageFault(filePageId, chunkOffset, chunk) : this.awaitPageFault(item);
        return item;
    }

    private Object initiatePageFault(long filePageId, long chunkOffset, Object[] chunk) throws IOException {
        BinaryLatch latch = new BinaryLatch();
        MuninnPage item = null;
        if (UnsafeUtil.compareAndSwapObject(chunk, chunkOffset, null, latch)) {
            item = this.pageFault(filePageId, this.swapper, chunkOffset, chunk, latch);
        }
        return item;
    }

    private Object awaitPageFault(Object item) {
        BinaryLatch latch = (BinaryLatch)item;
        latch.await();
        return null;
    }

    private MuninnPage pageFault(long filePageId, PageSwapper swapper, long chunkOffset, Object[] chunk, BinaryLatch latch) throws IOException {
        MuninnPage page2;
        PageFaultEvent faultEvent = this.pinEvent.beginPageFault();
        try {
            page2 = this.pagedFile.grabFreeAndExclusivelyLockedPage(faultEvent);
        }
        catch (Throwable throwable) {
            this.abortPageFault(throwable, chunk, chunkOffset, latch, faultEvent);
            throw throwable;
        }
        try {
            this.assertPagedFileStillMappedAndGetIdOfLastPage();
            page2.initBuffer();
            page2.fault(swapper, filePageId, faultEvent);
        }
        catch (Throwable throwable) {
            page2.unlockExclusive();
            this.abortPageFault(throwable, chunk, chunkOffset, latch, faultEvent);
            throw throwable;
        }
        UnsafeUtil.putObjectVolatile(chunk, chunkOffset, page2);
        this.convertPageFaultLock(page2);
        latch.release();
        faultEvent.done();
        return page2;
    }

    private void abortPageFault(Throwable throwable, Object[] chunk, long chunkOffset, BinaryLatch latch, PageFaultEvent faultEvent) throws IOException {
        UnsafeUtil.putObjectVolatile(chunk, chunkOffset, null);
        latch.release();
        faultEvent.done(throwable);
        this.pinEvent.done();
    }

    long assertPagedFileStillMappedAndGetIdOfLastPage() {
        return this.pagedFile.getLastPageId();
    }

    protected abstract void unpinCurrentPage();

    protected abstract void convertPageFaultLock(MuninnPage var1);

    protected abstract void pinCursorToPage(MuninnPage var1, long var2, PageSwapper var4);

    protected abstract boolean tryLockPage(MuninnPage var1);

    protected abstract void unlockPage(MuninnPage var1);

    protected abstract void releaseCursor();

    private long getBoundedPointer(int offset, int size2) {
        if (boundsCheck) {
            long can = this.pointer + (long)offset;
            long lim = this.pointer + (long)this.pageSize - (long)size2;
            long ref = Math.min(can, lim);
            this.outOfBounds |= (ref = Math.max(ref, this.pointer)) != can | lim < this.pointer;
            return ref;
        }
        return this.pointer + (long)offset;
    }

    @Override
    public final byte getByte() {
        long p = this.getBoundedPointer(this.offset, 1);
        byte b = UnsafeUtil.getByte(p);
        ++this.offset;
        return b;
    }

    @Override
    public byte getByte(int offset) {
        long p = this.getBoundedPointer(offset, 1);
        return UnsafeUtil.getByte(p);
    }

    @Override
    public void putByte(byte value) {
        long p = this.getBoundedPointer(this.offset, 1);
        UnsafeUtil.putByte(p, value);
        ++this.offset;
    }

    @Override
    public void putByte(int offset, byte value) {
        long p = this.getBoundedPointer(offset, 1);
        UnsafeUtil.putByte(p, value);
    }

    @Override
    public long getLong() {
        long value = this.getLong(this.offset);
        this.offset += 8;
        return value;
    }

    @Override
    public long getLong(int offset) {
        long value;
        long p = this.getBoundedPointer(offset, 8);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            value = UnsafeUtil.getLong(p);
            if (!UnsafeUtil.storeByteOrderIsNative) {
                value = Long.reverseBytes(value);
            }
        } else {
            value = this.getLongBigEndian(p);
        }
        return value;
    }

    private long getLongBigEndian(long p) {
        long a = UnsafeUtil.getByte(p) & 0xFF;
        long b = UnsafeUtil.getByte(p + 1L) & 0xFF;
        long c = UnsafeUtil.getByte(p + 2L) & 0xFF;
        long d = UnsafeUtil.getByte(p + 3L) & 0xFF;
        long e = UnsafeUtil.getByte(p + 4L) & 0xFF;
        long f = UnsafeUtil.getByte(p + 5L) & 0xFF;
        long g = UnsafeUtil.getByte(p + 6L) & 0xFF;
        long h = UnsafeUtil.getByte(p + 7L) & 0xFF;
        return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
    }

    @Override
    public void putLong(long value) {
        this.putLong(this.offset, value);
        this.offset += 8;
    }

    @Override
    public void putLong(int offset, long value) {
        long p = this.getBoundedPointer(offset, 8);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putLong(p, UnsafeUtil.storeByteOrderIsNative ? value : Long.reverseBytes(value));
        } else {
            this.putLongBigEndian(value, p);
        }
    }

    private void putLongBigEndian(long value, long p) {
        UnsafeUtil.putByte(p, (byte)(value >> 56));
        UnsafeUtil.putByte(p + 1L, (byte)(value >> 48));
        UnsafeUtil.putByte(p + 2L, (byte)(value >> 40));
        UnsafeUtil.putByte(p + 3L, (byte)(value >> 32));
        UnsafeUtil.putByte(p + 4L, (byte)(value >> 24));
        UnsafeUtil.putByte(p + 5L, (byte)(value >> 16));
        UnsafeUtil.putByte(p + 6L, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 7L, (byte)value);
    }

    @Override
    public int getInt() {
        int i = this.getInt(this.offset);
        this.offset += 4;
        return i;
    }

    @Override
    public int getInt(int offset) {
        long p = this.getBoundedPointer(offset, 4);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            int x = UnsafeUtil.getInt(p);
            return UnsafeUtil.storeByteOrderIsNative ? x : Integer.reverseBytes(x);
        }
        return this.getIntBigEndian(p);
    }

    private int getIntBigEndian(long p) {
        int a = UnsafeUtil.getByte(p) & 0xFF;
        int b = UnsafeUtil.getByte(p + 1L) & 0xFF;
        int c = UnsafeUtil.getByte(p + 2L) & 0xFF;
        int d = UnsafeUtil.getByte(p + 3L) & 0xFF;
        return a << 24 | b << 16 | c << 8 | d;
    }

    @Override
    public void putInt(int value) {
        this.putInt(this.offset, value);
        this.offset += 4;
    }

    @Override
    public void putInt(int offset, int value) {
        long p = this.getBoundedPointer(offset, 4);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putInt(p, UnsafeUtil.storeByteOrderIsNative ? value : Integer.reverseBytes(value));
        } else {
            this.putIntBigEndian(value, p);
        }
    }

    private void putIntBigEndian(int value, long p) {
        UnsafeUtil.putByte(p, (byte)(value >> 24));
        UnsafeUtil.putByte(p + 1L, (byte)(value >> 16));
        UnsafeUtil.putByte(p + 2L, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 3L, (byte)value);
    }

    @Override
    public void getBytes(byte[] data) {
        this.getBytes(data, 0, data.length);
    }

    @Override
    public void getBytes(byte[] data, int arrayOffset, int length2) {
        long p = this.getBoundedPointer(this.offset, length2);
        if (!this.outOfBounds) {
            for (int i = 0; i < length2; ++i) {
                data[arrayOffset + i] = UnsafeUtil.getByte(p + (long)i);
            }
        }
        this.offset += length2;
    }

    @Override
    public final void putBytes(byte[] data) {
        this.putBytes(data, 0, data.length);
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length2) {
        long p = this.getBoundedPointer(this.offset, length2);
        if (!this.outOfBounds) {
            for (int i = 0; i < length2; ++i) {
                byte b = data[arrayOffset + i];
                UnsafeUtil.putByte(p + (long)i, b);
            }
        }
        this.offset += length2;
    }

    @Override
    public final short getShort() {
        short s2 = this.getShort(this.offset);
        this.offset += 2;
        return s2;
    }

    @Override
    public short getShort(int offset) {
        long p = this.getBoundedPointer(offset, 2);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            short x = UnsafeUtil.getShort(p);
            return UnsafeUtil.storeByteOrderIsNative ? x : Short.reverseBytes(x);
        }
        return this.getShortBigEndian(p);
    }

    private short getShortBigEndian(long p) {
        short a = (short)(UnsafeUtil.getByte(p) & 0xFF);
        short b = (short)(UnsafeUtil.getByte(p + 1L) & 0xFF);
        return (short)(a << 8 | b);
    }

    @Override
    public void putShort(short value) {
        this.putShort(this.offset, value);
        this.offset += 2;
    }

    @Override
    public void putShort(int offset, short value) {
        long p = this.getBoundedPointer(offset, 2);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putShort(p, UnsafeUtil.storeByteOrderIsNative ? value : Short.reverseBytes(value));
        } else {
            this.putShortBigEndian(value, p);
        }
    }

    private void putShortBigEndian(short value, long p) {
        UnsafeUtil.putByte(p, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 1L, (byte)value);
    }

    @Override
    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        int sourcePageSize = this.getCurrentPageSize();
        int targetPageSize = targetCursor.getCurrentPageSize();
        if (targetCursor.getClass() != MuninnWritePageCursor.class) {
            throw new IllegalArgumentException("Target cursor must be writable");
        }
        if (sourceOffset >= 0 & targetOffset >= 0 & sourceOffset < sourcePageSize & targetOffset < targetPageSize & lengthInBytes > 0) {
            MuninnPageCursor cursor = (MuninnPageCursor)targetCursor;
            int remainingSource = sourcePageSize - sourceOffset;
            int remainingTarget = targetPageSize - targetOffset;
            int bytes2 = Math.min(lengthInBytes, Math.min(remainingSource, remainingTarget));
            UnsafeUtil.copyMemory(this.pointer + (long)sourceOffset, cursor.pointer + (long)targetOffset, bytes2);
            return bytes2;
        }
        this.outOfBounds = true;
        return 0;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    @Override
    public boolean checkAndClearBoundsFlag() {
        MuninnPageCursor cursor = this;
        boolean result2 = false;
        do {
            result2 |= cursor.outOfBounds;
            cursor.outOfBounds = false;
        } while ((cursor = cursor.linkedCursor) != null);
        return result2;
    }

    @Override
    public void checkAndClearCursorException() throws CursorException {
        MuninnPageCursor cursor = this;
        do {
            Object error;
            if ((error = cursor.cursorException) == null) continue;
            this.clearCursorError(cursor);
            if (usePreciseCursorErrorStackTraces) {
                throw (CursorExceptionWithPreciseStackTrace)error;
            }
            throw new CursorException((String)error);
        } while ((cursor = cursor.linkedCursor) != null);
    }

    @Override
    public void clearCursorException() {
        this.clearCursorError(this);
    }

    private void clearCursorError(MuninnPageCursor cursor) {
        while (cursor != null) {
            cursor.cursorException = null;
            cursor = cursor.linkedCursor;
        }
    }

    @Override
    public void raiseOutOfBounds() {
        this.outOfBounds = true;
    }

    @Override
    public void setCursorException(String message) {
        Objects.requireNonNull(message);
        this.cursorException = usePreciseCursorErrorStackTraces ? new CursorExceptionWithPreciseStackTrace(message) : message;
    }
}

