/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.StoreFileChannelUnwrapper;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.FileLockException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import sun.nio.ch.FileChannelImpl;

public class SingleFilePageSwapper
implements PageSwapper {
    private static final int channelStripePower = Integer.getInteger("org.neo4j.io.pagecache.implSingleFilePageSwapper.channelStripePower", SingleFilePageSwapper.defaultChannelStripePower());
    private static final int channelStripeShift = Integer.getInteger("org.neo4j.io.pagecache.implSingleFilePageSwapper.channelStripeShift", 4);
    private static final int channelStripeCount = 1 << channelStripePower;
    private static final int channelStripeMask = channelStripeCount - 1;
    private static final int tokenChannelStripe = 0;
    private static final long tokenFilePageId = 0L;
    private static final long fileSizeOffset = UnsafeUtil.getFieldOffset(SingleFilePageSwapper.class, "fileSize");
    private static final ThreadLocal<ByteBuffer> proxyCache = new ThreadLocal();
    private static final MethodHandle positionLockGetter = SingleFilePageSwapper.getPositionLockGetter();
    private final FileSystemAbstraction fs;
    private final File file;
    private final int filePageSize;
    private volatile PageEvictionCallback onEviction;
    private final StoreChannel[] channels;
    private FileLock fileLock;
    private final boolean hasPositionLock;
    private boolean closed;
    private volatile long fileSize;

    private static int defaultChannelStripePower() {
        int vcores = Runtime.getRuntime().availableProcessors();
        int stripePower = 32 - Integer.numberOfLeadingZeros(vcores - 1);
        return Math.min(64, Math.max(1, stripePower));
    }

    private static MethodHandle getPositionLockGetter() {
        try {
            MethodHandles.Lookup lookup2 = MethodHandles.lookup();
            Field field2 = FileChannelImpl.class.getDeclaredField("positionLock");
            field2.setAccessible(true);
            return lookup2.unreflectGetter(field2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ByteBuffer proxy(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf = proxyCache.get();
        if (buf != null) {
            UnsafeUtil.initDirectByteBuffer(buf, buffer, bufferLength);
            return buf;
        }
        return SingleFilePageSwapper.createAndGetNewBuffer(buffer, bufferLength);
    }

    private static ByteBuffer createAndGetNewBuffer(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf;
        try {
            buf = UnsafeUtil.newDirectByteBuffer(buffer, bufferLength);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        proxyCache.set(buf);
        return buf;
    }

    public SingleFilePageSwapper(File file, FileSystemAbstraction fs, int filePageSize, PageEvictionCallback onEviction) throws IOException {
        this.fs = fs;
        this.file = file;
        this.channels = new StoreChannel[channelStripeCount];
        for (int i = 0; i < channelStripeCount; ++i) {
            this.channels[i] = fs.open(file, "rw");
        }
        this.filePageSize = filePageSize;
        this.onEviction = onEviction;
        this.increaseFileSizeTo(this.channels[0].size());
        try {
            this.acquireLock();
        }
        catch (IOException e) {
            this.closeAndCollectExceptions(0, e);
        }
        this.hasPositionLock = this.channels[0].getClass() == StoreFileChannel.class && StoreFileChannelUnwrapper.unwrap(this.channels[0]).getClass() == FileChannelImpl.class;
    }

    private void increaseFileSizeTo(long newFileSize) {
        long currentFileSize;
        while ((currentFileSize = this.getCurrentFileSize()) < newFileSize && !UnsafeUtil.compareAndSwapLong(this, fileSizeOffset, currentFileSize, newFileSize)) {
        }
    }

    private long getCurrentFileSize() {
        return UnsafeUtil.getLongVolatile(this, fileSizeOffset);
    }

    private void setCurrentFileSize(long size2) {
        UnsafeUtil.putLongVolatile(this, fileSizeOffset, size2);
    }

    private void acquireLock() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        try {
            this.fileLock = this.channels[0].tryLock();
            if (this.fileLock == null) {
                throw new FileLockException(this.file);
            }
        }
        catch (OverlappingFileLockException e) {
            throw new FileLockException(this.file, e);
        }
    }

    private StoreChannel channel(long filePageId) {
        int stripe = SingleFilePageSwapper.stripe(filePageId);
        return this.channels[stripe];
    }

    private static int stripe(long filePageId) {
        return (int)(filePageId >>> channelStripeShift) & channelStripeMask;
    }

    private int swapIn(StoreChannel channel, Page page2, long fileOffset, int filePageSize) throws IOException {
        int cachePageSize = page2.size();
        long address = page2.address();
        int readTotal = 0;
        try {
            int read;
            ByteBuffer bufferProxy = SingleFilePageSwapper.proxy(address, filePageSize);
            while ((read = channel.read(bufferProxy, fileOffset + (long)readTotal)) != -1 && (readTotal += read) < filePageSize) {
            }
            assert (readTotal >= 0 && filePageSize <= cachePageSize && readTotal <= filePageSize) : String.format("pointer = %h, readTotal = %s, length = %s, page size = %s", address, readTotal, filePageSize, cachePageSize);
            UnsafeUtil.setMemory(address + (long)readTotal, filePageSize - readTotal, MuninnPageCache.ZERO_BYTE);
            return readTotal;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            String msg = String.format("Read failed after %s of %s bytes from fileOffset %s", readTotal, filePageSize, fileOffset);
            throw new IOException(msg, e);
        }
    }

    private int swapOut(Page page2, long fileOffset, StoreChannel channel) throws IOException {
        long address = page2.address();
        try {
            ByteBuffer bufferProxy = SingleFilePageSwapper.proxy(address, this.filePageSize);
            channel.writeAll(bufferProxy, fileOffset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        return this.filePageSize;
    }

    private void clear(Page page2) {
        UnsafeUtil.setMemory(page2.address(), page2.size(), MuninnPageCache.ZERO_BYTE);
    }

    @Override
    public long read(long filePageId, Page page2) throws IOException {
        long fileOffset = this.pageIdToPosition(filePageId);
        try {
            if (fileOffset < this.getCurrentFileSize()) {
                return this.swapIn(this.channel(filePageId), page2, fileOffset, this.filePageSize);
            }
            this.clear(page2);
        }
        catch (ClosedChannelException e) {
            this.tryReopen(filePageId, e);
            boolean interrupted = Thread.interrupted();
            long bytesRead = this.read(filePageId, page2);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesRead;
        }
        return 0L;
    }

    @Override
    public long read(long startFilePageId, Page[] pages, int arrayOffset, int length2) throws IOException {
        if (positionLockGetter != null && this.hasPositionLock) {
            try {
                return this.readPositionedVectoredToFileChannel(startFilePageId, pages, arrayOffset, length2);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.readPositionedVectoredFallback(startFilePageId, pages, arrayOffset, length2);
    }

    private long readPositionedVectoredToFileChannel(long startFilePageId, Page[] pages, int arrayOffset, int length2) throws Exception {
        ByteBuffer[] srcs;
        long fileOffset = this.pageIdToPosition(startFilePageId);
        FileChannel channel = this.unwrappedChannel(startFilePageId);
        long bytesRead = this.lockPositionReadVector(startFilePageId, channel, fileOffset, srcs = this.convertToByteBuffers(pages, arrayOffset, length2));
        if (bytesRead == -1L) {
            for (Page page2 : pages) {
                UnsafeUtil.setMemory(page2.address(), this.filePageSize, MuninnPageCache.ZERO_BYTE);
            }
            return 0L;
        }
        if (bytesRead < (long)this.filePageSize * (long)length2) {
            int pagesRead = (int)(bytesRead / (long)this.filePageSize);
            int bytesReadIntoLastReadPage = (int)(bytesRead % (long)this.filePageSize);
            int pagesNeedingZeroing = length2 - pagesRead;
            for (int i = 0; i < pagesNeedingZeroing; ++i) {
                Page page3 = pages[arrayOffset + pagesRead + i];
                long bytesToZero = this.filePageSize;
                long address = page3.address();
                if (i == 0) {
                    address += (long)bytesReadIntoLastReadPage;
                    bytesToZero -= (long)bytesReadIntoLastReadPage;
                }
                UnsafeUtil.setMemory(address, bytesToZero, MuninnPageCache.ZERO_BYTE);
            }
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionReadVector(long filePageId, FileChannel channel, long fileOffset, ByteBuffer[] srcs) throws IOException {
        try {
            long toRead = (long)this.filePageSize * (long)srcs.length;
            long readTotal = 0L;
            Object object = this.positionLock(channel);
            synchronized (object) {
                long read;
                channel.position(fileOffset);
                while ((read = channel.read(srcs)) != -1L && (readTotal += read) < toRead) {
                }
                return readTotal;
            }
        }
        catch (ClosedChannelException e) {
            this.tryReopen(filePageId, e);
            boolean interrupted = Thread.interrupted();
            channel = this.unwrappedChannel(filePageId);
            long bytesWritten = this.lockPositionReadVector(filePageId, channel, fileOffset, srcs);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesWritten;
        }
    }

    private int readPositionedVectoredFallback(long startFilePageId, Page[] pages, int arrayOffset, int length2) throws IOException {
        int bytes2 = 0;
        for (int i = 0; i < length2; ++i) {
            bytes2 = (int)((long)bytes2 + this.read(startFilePageId + (long)i, pages[arrayOffset + i]));
        }
        return bytes2;
    }

    @Override
    public long write(long filePageId, Page page2) throws IOException {
        long fileOffset = this.pageIdToPosition(filePageId);
        this.increaseFileSizeTo(fileOffset + (long)this.filePageSize);
        try {
            StoreChannel channel = this.channel(filePageId);
            return this.swapOut(page2, fileOffset, channel);
        }
        catch (ClosedChannelException e) {
            this.tryReopen(filePageId, e);
            boolean interrupted = Thread.interrupted();
            long bytesWritten = this.write(filePageId, page2);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesWritten;
        }
    }

    @Override
    public long write(long startFilePageId, Page[] pages, int arrayOffset, int length2) throws IOException {
        if (positionLockGetter != null && this.hasPositionLock) {
            try {
                return this.writePositionedVectoredToFileChannel(startFilePageId, pages, arrayOffset, length2);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.writePositionVectoredFallback(startFilePageId, pages, arrayOffset, length2);
    }

    private long writePositionedVectoredToFileChannel(long startFilePageId, Page[] pages, int arrayOffset, int length2) throws Exception {
        long fileOffset = this.pageIdToPosition(startFilePageId);
        this.increaseFileSizeTo(fileOffset + (long)this.filePageSize * (long)length2);
        FileChannel channel = this.unwrappedChannel(startFilePageId);
        ByteBuffer[] srcs = this.convertToByteBuffers(pages, arrayOffset, length2);
        return this.lockPositionWriteVector(startFilePageId, channel, fileOffset, srcs);
    }

    private ByteBuffer[] convertToByteBuffers(Page[] pages, int arrayOffset, int length2) throws Exception {
        ByteBuffer[] buffers = new ByteBuffer[length2];
        for (int i = 0; i < length2; ++i) {
            Page page2 = pages[arrayOffset + i];
            buffers[i] = UnsafeUtil.newDirectByteBuffer(page2.address(), this.filePageSize);
        }
        return buffers;
    }

    private FileChannel unwrappedChannel(long startFilePageId) {
        StoreChannel storeChannel = this.channel(startFilePageId);
        return StoreFileChannelUnwrapper.unwrap(storeChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionWriteVector(long filePageId, FileChannel channel, long fileOffset, ByteBuffer[] srcs) throws IOException {
        try {
            long toWrite = (long)this.filePageSize * (long)srcs.length;
            long bytesWritten = 0L;
            Object object = this.positionLock(channel);
            synchronized (object) {
                channel.position(fileOffset);
                while ((bytesWritten += channel.write(srcs)) < toWrite) {
                }
                return bytesWritten;
            }
        }
        catch (ClosedChannelException e) {
            this.tryReopen(filePageId, e);
            boolean interrupted = Thread.interrupted();
            channel = this.unwrappedChannel(filePageId);
            long bytesWritten = this.lockPositionWriteVector(filePageId, channel, fileOffset, srcs);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesWritten;
        }
    }

    private Object positionLock(FileChannel channel) {
        FileChannelImpl impl = (FileChannelImpl)channel;
        try {
            return positionLockGetter.invokeExact(impl);
        }
        catch (Throwable th) {
            throw new LinkageError("No getter for FileChannel.positionLock", th);
        }
    }

    private int writePositionVectoredFallback(long startFilePageId, Page[] pages, int arrayOffset, int length2) throws IOException {
        int bytes2 = 0;
        for (int i = 0; i < length2; ++i) {
            bytes2 = (int)((long)bytes2 + this.write(startFilePageId + (long)i, pages[arrayOffset + i]));
        }
        return bytes2;
    }

    @Override
    public void evicted(long filePageId, Page page2) {
        PageEvictionCallback callback = this.onEviction;
        if (callback != null) {
            callback.onEvict(filePageId, page2);
        }
    }

    @Override
    public File file() {
        return this.file;
    }

    private long pageIdToPosition(long pageId) {
        return (long)this.filePageSize * pageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFilePageSwapper that = (SingleFilePageSwapper)o;
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private synchronized void tryReopen(long filePageId, ClosedChannelException closedException) throws ClosedChannelException {
        int stripe = SingleFilePageSwapper.stripe(filePageId);
        StoreChannel channel = this.channels[stripe];
        if (channel.isOpen()) {
            return;
        }
        if (this.closed) {
            throw closedException;
        }
        try {
            this.channels[stripe] = this.fs.open(this.file, "rw");
            if (stripe == 0) {
                this.acquireLock();
            }
        }
        catch (IOException e) {
            closedException.addSuppressed(e);
            throw closedException;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        try {
            this.closeAndCollectExceptions(0, null);
        }
        finally {
            this.onEviction = null;
        }
    }

    private void closeAndCollectExceptions(int channelIndex, IOException exception) throws IOException {
        if (channelIndex == this.channels.length) {
            if (exception != null) {
                throw exception;
            }
            return;
        }
        try {
            this.channels[channelIndex].close();
        }
        catch (IOException e) {
            if (exception == null) {
                exception = e;
            }
            exception.addSuppressed(e);
        }
        this.closeAndCollectExceptions(channelIndex + 1, exception);
    }

    @Override
    public synchronized void closeAndDelete() throws IOException {
        this.close();
        this.fs.deleteFile(this.file);
    }

    @Override
    public void force() throws IOException {
        block2: {
            try {
                this.channel(0L).force(false);
            }
            catch (ClosedChannelException e) {
                this.tryReopen(0L, e);
                boolean interrupted = Thread.interrupted();
                this.force();
                if (!interrupted) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public long getLastPageId() throws IOException {
        long channelSize = this.getCurrentFileSize();
        if (channelSize == 0L) {
            return -1L;
        }
        long div2 = channelSize / (long)this.filePageSize;
        long mod = channelSize % (long)this.filePageSize;
        return mod == 0L ? div2 - 1L : div2;
    }

    @Override
    public void truncate() throws IOException {
        block2: {
            this.setCurrentFileSize(0L);
            try {
                this.channel(0L).truncate(0L);
            }
            catch (ClosedChannelException e) {
                this.tryReopen(0L, e);
                boolean interrupted = Thread.interrupted();
                this.truncate();
                if (!interrupted) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return "SingleFilePageSwapper{filePageSize=" + this.filePageSize + ", file=" + this.file + '}';
    }
}

