/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.io.fs.DelegatingPath;

public abstract class DelegatingFileSystemProvider
extends FileSystemProvider {
    private final FileSystemProvider delegate;

    public DelegatingFileSystemProvider(FileSystemProvider delegate) {
        this.delegate = delegate;
    }

    public FileSystemProvider getDelegate() {
        return this.delegate;
    }

    @Override
    public String getScheme() {
        return this.delegate.getScheme();
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return this.delegate.newFileSystem(uri, env);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.delegate.getFileSystem(uri);
    }

    @Override
    public Path getPath(URI uri) {
        return this.wrapPath(this.delegate.getPath(uri));
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.delegate.newByteChannel(this.getDelegate(path), options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
        final DirectoryStream<Path> stream = this.delegate.newDirectoryStream(this.getDelegate(dir), filter2);
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                final Iterator iterator2 = stream.iterator();
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public Path next() {
                        return DelegatingFileSystemProvider.this.wrapPath((Path)iterator2.next());
                    }

                    @Override
                    public void remove() {
                        iterator2.next();
                    }
                };
            }

            @Override
            public void close() throws IOException {
                stream.close();
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.delegate.createDirectory(this.getDelegate(dir), attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.delegate.delete(this.getDelegate(path));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.delegate.copy(this.getDelegate(source), this.getDelegate(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.delegate.move(this.getDelegate(source), this.getDelegate(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return this.delegate.isSameFile(this.getDelegate(path), this.getDelegate(path2));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.delegate.isHidden(this.getDelegate(path));
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.delegate.getFileStore(this.getDelegate(path));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.delegate.checkAccess(this.getDelegate(path), modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return this.delegate.getFileAttributeView(this.getDelegate(path), type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.delegate.readAttributes(this.getDelegate(path), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.delegate.readAttributes(path, attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.delegate.setAttribute(this.getDelegate(path), attribute, value, options);
    }

    private Path getDelegate(Path path) {
        return DelegatingPath.getDelegate(path);
    }

    private Path wrapPath(Path path) {
        return path == null ? null : this.createDelegate(path);
    }

    protected abstract Path createDelegate(Path var1);
}

