/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreFileChannel;

public class DefaultFileSystemAbstraction
implements FileSystemAbstraction {
    static final String UNABLE_TO_CREATE_DIRECTORY_FORMAT = "Unable to create directory path [%s] for Neo4j store.";
    private final Map<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem> thirdPartyFileSystems = new HashMap<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem>();

    @Override
    public StoreFileChannel open(File fileName, String mode) throws IOException {
        FileChannel channel = new RandomAccessFile(fileName, mode).getChannel();
        return this.getStoreFileChannel(channel);
    }

    @Override
    public OutputStream openAsOutputStream(File fileName, boolean append2) throws IOException {
        return new FileOutputStream(fileName, append2);
    }

    @Override
    public InputStream openAsInputStream(File fileName) throws IOException {
        return new FileInputStream(fileName);
    }

    @Override
    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(fileName), charset);
    }

    @Override
    public Writer openAsWriter(File fileName, Charset charset, boolean append2) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append2), charset);
    }

    @Override
    public StoreFileChannel create(File fileName) throws IOException {
        return this.open(fileName, "rw");
    }

    @Override
    public boolean mkdir(File fileName) {
        return fileName.mkdir();
    }

    @Override
    public void mkdirs(File path) throws IOException {
        if (path.exists()) {
            return;
        }
        path.mkdirs();
        if (path.exists()) {
            return;
        }
        throw new IOException(String.format(UNABLE_TO_CREATE_DIRECTORY_FORMAT, path));
    }

    @Override
    public boolean fileExists(File fileName) {
        return fileName.exists();
    }

    @Override
    public long getFileSize(File fileName) {
        return fileName.length();
    }

    @Override
    public boolean deleteFile(File fileName) {
        return FileUtils.deleteFile(fileName);
    }

    @Override
    public void deleteRecursively(File directory) throws IOException {
        FileUtils.deleteRecursively(directory);
    }

    @Override
    public boolean renameFile(File from2, File to2) throws IOException {
        return FileUtils.renameFile(from2, to2);
    }

    @Override
    public File[] listFiles(File directory) {
        return directory.listFiles();
    }

    @Override
    public File[] listFiles(File directory, FilenameFilter filter2) {
        return directory.listFiles(filter2);
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    @Override
    public void moveToDirectory(File file, File toDirectory) throws IOException {
        FileUtils.moveFileToDirectory(file, toDirectory);
    }

    @Override
    public void copyFile(File from2, File to2) throws IOException {
        FileUtils.copyFile(from2, to2);
    }

    @Override
    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        FileUtils.copyRecursively(fromDirectory, toDirectory);
    }

    @Override
    public synchronized <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        FileSystemAbstraction.ThirdPartyFileSystem fileSystem = this.thirdPartyFileSystems.get(clazz);
        if (fileSystem == null) {
            fileSystem = (FileSystemAbstraction.ThirdPartyFileSystem)creator.apply(clazz);
            this.thirdPartyFileSystems.put(clazz, fileSystem);
        }
        return (K)((FileSystemAbstraction.ThirdPartyFileSystem)clazz.cast(fileSystem));
    }

    @Override
    public void truncate(File path, long size2) throws IOException {
        FileUtils.truncateFile(path, size2);
    }

    protected StoreFileChannel getStoreFileChannel(FileChannel channel) {
        return new StoreFileChannel(channel);
    }
}

