/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;

public abstract class LuceneUtil {
    static void close(IndexWriter writer) {
        LuceneUtil.close((Object)writer);
    }

    static void close(IndexSearcher searcher) {
        LuceneUtil.close((Object)searcher);
    }

    static void close(IndexReader reader) {
        LuceneUtil.close((Object)reader);
    }

    private static void close(Object object) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof IndexWriter) {
                ((IndexWriter)object).close();
            } else if (object instanceof IndexReader) {
                ((IndexReader)object).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Query rangeQuery(String key, Number from2, Number to2, boolean includeFrom, boolean includeTo) {
        if (from2 instanceof Long || to2 instanceof Long) {
            return NumericRangeQuery.newLongRange(key, from2 != null ? from2.longValue() : 0L, to2 != null ? to2.longValue() : Long.MAX_VALUE, includeFrom, includeTo);
        }
        if (from2 instanceof Double || to2 instanceof Double) {
            return NumericRangeQuery.newDoubleRange(key, from2 != null ? from2.doubleValue() : 0.0, to2 != null ? to2.doubleValue() : Double.MAX_VALUE, includeFrom, includeTo);
        }
        if (from2 instanceof Float || to2 instanceof Float) {
            return NumericRangeQuery.newFloatRange(key, Float.valueOf(from2 != null ? from2.floatValue() : 0.0f), Float.valueOf(to2 != null ? to2.floatValue() : Float.MAX_VALUE), includeFrom, includeTo);
        }
        return NumericRangeQuery.newIntRange(key, from2 != null ? from2.intValue() : 0, to2 != null ? to2.intValue() : Integer.MAX_VALUE, includeFrom, includeTo);
    }
}

