/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.LuceneBatchInserterIndex;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;
import org.neo4j.unsafe.batchinsert.BatchInserterIndexProvider;
import org.neo4j.unsafe.batchinsert.BatchRelationship;
import org.neo4j.unsafe.batchinsert.internal.BatchInserterImpl;

public class LuceneBatchInserterIndexProviderNewImpl
implements BatchInserterIndexProvider {
    private final BatchInserter inserter;
    private final Map<IndexIdentifier, LuceneBatchInserterIndex> indexes = new HashMap<IndexIdentifier, LuceneBatchInserterIndex>();
    final IndexConfigStore indexStore;
    private LuceneBatchInserterIndex.RelationshipLookup relationshipLookup;

    public LuceneBatchInserterIndexProviderNewImpl(final BatchInserter inserter) {
        this.inserter = inserter;
        this.indexStore = ((BatchInserterImpl)inserter).getIndexStore();
        this.relationshipLookup = new LuceneBatchInserterIndex.RelationshipLookup(){

            @Override
            public EntityId lookup(long id) {
                BatchRelationship rel = inserter.getRelationshipById(id);
                return new EntityId.RelationshipData(id, rel.getStartNode(), rel.getEndNode());
            }
        };
    }

    @Override
    public BatchInserterIndex nodeIndex(String indexName, Map<String, String> config) {
        this.config(Node.class, indexName, config);
        return this.index(new IndexIdentifier(IndexEntityType.Node, indexName), config);
    }

    private Map<String, String> config(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> config) {
        if (config != null) {
            config = MapUtil.stringMap(new HashMap<String, String>(config), "provider", "lucene");
            this.indexStore.setIfNecessary(cls, indexName, config);
            return config;
        }
        return this.indexStore.get(cls, indexName);
    }

    @Override
    public BatchInserterIndex relationshipIndex(String indexName, Map<String, String> config) {
        this.config(Relationship.class, indexName, config);
        return this.index(new IndexIdentifier(IndexEntityType.Relationship, indexName), config);
    }

    private BatchInserterIndex index(IndexIdentifier identifier2, Map<String, String> config) {
        LuceneBatchInserterIndex index = this.indexes.get(identifier2);
        if (index == null) {
            index = new LuceneBatchInserterIndex(new File(this.inserter.getStoreDir()), identifier2, config, this.relationshipLookup);
            this.indexes.put(identifier2, index);
        }
        return index;
    }

    @Override
    public void shutdown() {
        for (LuceneBatchInserterIndex index : this.indexes.values()) {
            index.shutdown();
        }
    }
}

