/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.LruCache;
import org.neo4j.index.impl.lucene.legacy.ConstantScoreIterator;
import org.neo4j.index.impl.lucene.legacy.DocToIdIterator;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.IndexType;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;

class LuceneBatchInserterIndex
implements BatchInserterIndex {
    private final IndexIdentifier identifier;
    private final IndexType type;
    private IndexWriter writer;
    private SearcherManager searcherManager;
    private final boolean createdNow;
    private Map<String, LruCache<String, Collection<EntityId>>> cache;
    private int updateCount;
    private final int commitBatchSize = 500000;
    private final RelationshipLookup relationshipLookup;

    LuceneBatchInserterIndex(File dbStoreDir, IndexIdentifier identifier2, Map<String, String> config, RelationshipLookup relationshipLookup) {
        File storeDir = this.getStoreDir(dbStoreDir);
        this.createdNow = !LuceneDataSource.getFileDirectory(storeDir, identifier2).exists();
        this.identifier = identifier2;
        this.type = IndexType.getIndexType(config);
        this.relationshipLookup = relationshipLookup;
        this.writer = this.instantiateWriter(storeDir);
        this.searcherManager = LuceneBatchInserterIndex.instantiateSearcherManager(this.writer);
    }

    @Override
    public void add(long id, Map<String, Object> properties) {
        try {
            Document document = IndexType.newDocument(this.entityId(id));
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.addSingleProperty(id, document, key, value);
            }
            this.writer.addDocument(document);
            if (++this.updateCount == 500000) {
                this.writer.commit();
                this.updateCount = 0;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private EntityId entityId(long id) {
        if (this.identifier.entityType == IndexEntityType.Node) {
            return new EntityId.IdData(id);
        }
        return this.relationshipLookup.lookup(id);
    }

    private void addSingleProperty(long entityId, Document document, String key, Object value) {
        for (Object oneValue : IoPrimitiveUtils.asArray(value)) {
            boolean isValueContext = oneValue instanceof ValueContext;
            oneValue = isValueContext ? ((ValueContext)oneValue).getCorrectValue() : oneValue.toString();
            this.type.addToDocument(document, key, oneValue);
            if (!this.createdNow) continue;
            this.addToCache(entityId, key, oneValue);
        }
    }

    private void addToCache(long entityId, String key, Object value) {
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<EntityId>> cache = this.cache.get(key);
        if (cache != null) {
            Collection<EntityId> ids2 = cache.get(valueAsString);
            if (ids2 == null) {
                ids2 = new HashSet<EntityId>();
                cache.put(valueAsString, ids2);
            }
            ids2.add(new EntityId.IdData(entityId));
        }
    }

    private void addToCache(Collection<EntityId> ids2, String key, Object value) {
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<EntityId>> cache = this.cache.get(key);
        if (cache != null) {
            cache.put(valueAsString, ids2);
        }
    }

    private LegacyIndexHits getFromCache(String key, Object value) {
        Collection<EntityId> ids2;
        if (this.cache == null) {
            return null;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<EntityId>> cache = this.cache.get(key);
        if (cache != null && (ids2 = cache.get(valueAsString)) != null) {
            return new ConstantScoreIterator(ids2, Float.NaN);
        }
        return null;
    }

    @Override
    public void updateOrAdd(long entityId, Map<String, Object> properties) {
        try {
            this.removeFromCache(entityId);
            this.writer.deleteDocuments(this.type.idTermQuery(entityId));
            this.add(entityId, properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(long entityId) throws IOException, CorruptIndexException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            Query query = this.type.idTermQuery(entityId);
            TopDocs docs = searcher.search(query, 1);
            if (docs.totalHits > 0) {
                Document document = searcher.doc(docs.scoreDocs[0].doc);
                for (IndexableField field2 : document.getFields()) {
                    String key = field2.name();
                    String value = field2.stringValue();
                    this.removeFromCache(entityId, key, value);
                }
            }
        }
        finally {
            this.searcherManager.release(searcher);
        }
    }

    private void removeFromCache(long entityId, String key, Object value) {
        Collection<EntityId> ids2;
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<EntityId>> cache = this.cache.get(key);
        if (cache != null && (ids2 = cache.get(valueAsString)) != null) {
            ids2.remove(new EntityId.IdData(entityId));
        }
    }

    private IndexWriter instantiateWriter(File folder) {
        Directory dir = null;
        try {
            dir = LuceneDataSource.getDirectory(folder, this.identifier);
            IndexWriterConfig writerConfig = new IndexWriterConfig(this.type.analyzer);
            writerConfig.setRAMBufferSizeMB(this.determineGoodBufferSize(writerConfig.getRAMBufferSizeMB()));
            return new IndexWriter(dir, writerConfig);
        }
        catch (IOException e) {
            IOUtils.closeAllSilently((AutoCloseable[])new Directory[]{dir});
            throw new RuntimeException(e);
        }
    }

    private double determineGoodBufferSize(double atLeast) {
        double heapHint = Runtime.getRuntime().maxMemory() / 0xE00000L;
        double result2 = Math.max(atLeast, heapHint);
        return Math.min(result2, 700.0);
    }

    private static SearcherManager instantiateSearcherManager(IndexWriter writer) {
        try {
            return new SearcherManager(writer, true, new SearcherFactory());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeSearcher() {
        try {
            if (this.searcherManager != null) {
                this.searcherManager.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.searcherManager = null;
        }
    }

    private void closeWriter() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writer = null;
        }
    }

    private IndexHits<Long> query(Query query, final String key, final Object value) {
        IndexSearcher searcher;
        try {
            searcher = (IndexSearcher)this.searcherManager.acquire();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            DocValuesCollector collector = new DocValuesCollector(true);
            searcher.search(query, collector);
            IndexHits<Document> result2 = collector.getIndexHits(Sort.RELEVANCE);
            DocToIdIterator primitiveHits = null;
            primitiveHits = key == null || this.cache == null || !this.cache.containsKey(key) ? new DocToIdIterator(result2, Collections.emptyList(), null, PrimitiveLongCollections.emptySet()) : new DocToIdIterator(result2, Collections.emptyList(), null, PrimitiveLongCollections.emptySet()){
                private final Collection<EntityId> ids;
                {
                    super(source, exclude, searcherOrNull, idsModifiedInTransactionState);
                    this.ids = new ArrayList<EntityId>();
                }

                @Override
                protected boolean fetchNext() {
                    if (super.fetchNext()) {
                        this.ids.add(new EntityId.IdData(this.next));
                        return true;
                    }
                    LuceneBatchInserterIndex.this.addToCache(this.ids, key, value);
                    return false;
                }
            };
            IndexHits<Long> indexHits = this.wrapIndexHits(primitiveHits);
            return indexHits;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.searcherManager.release(searcher);
            }
            catch (IOException iOException) {}
        }
    }

    private IndexHits<Long> wrapIndexHits(final LegacyIndexHits ids2) {
        return new IndexHits<Long>(){

            @Override
            public boolean hasNext() {
                return ids2.hasNext();
            }

            @Override
            public Long next() {
                return ids2.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ResourceIterator<Long> iterator() {
                return this;
            }

            @Override
            public int size() {
                return ids2.size();
            }

            @Override
            public void close() {
                ids2.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long getSingle() {
                try {
                    long singleId = PrimitiveLongCollections.single(ids2, -1L);
                    Long l = singleId == -1L ? null : Long.valueOf(singleId);
                    return l;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public float currentScore() {
                return 0.0f;
            }
        };
    }

    @Override
    public IndexHits<Long> get(String key, Object value) {
        LegacyIndexHits cached = this.getFromCache(key, value);
        return cached != null ? this.wrapIndexHits(cached) : this.query(this.type.get(key, value), key, value);
    }

    @Override
    public IndexHits<Long> query(String key, Object queryOrQueryObject) {
        return this.query(this.type.query(key, queryOrQueryObject, null), null, null);
    }

    @Override
    public IndexHits<Long> query(Object queryOrQueryObject) {
        return this.query(this.type.query(null, queryOrQueryObject, null), null, null);
    }

    public void shutdown() {
        this.closeSearcher();
        this.closeWriter();
    }

    private File getStoreDir(File dbStoreDir) {
        File dir = new File(dbStoreDir, "index");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Unable to create directory path[" + dir.getAbsolutePath() + "] for Neo4j store.");
        }
        return dir;
    }

    @Override
    public void flush() {
        try {
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setCacheCapacity(String key, int size2) {
        LruCache<String, Collection<EntityId>> cache;
        if (this.cache == null) {
            this.cache = new HashMap<String, LruCache<String, Collection<EntityId>>>();
        }
        if ((cache = this.cache.get(key)) != null) {
            cache.resize(size2);
        } else {
            cache = new LruCache("Batch inserter cache for " + key, size2);
            this.cache.put(key, cache);
        }
    }

    static interface RelationshipLookup {
        public EntityId lookup(long var1);
    }
}

