/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.IndexType;
import org.neo4j.kernel.impl.index.IndexConfigStore;

class IndexTypeCache {
    private final Map<IndexIdentifier, Pair<Integer, IndexType>> cache = Collections.synchronizedMap(new HashMap());
    private final IndexConfigStore indexStore;

    IndexTypeCache(IndexConfigStore indexStore) {
        this.indexStore = indexStore;
    }

    IndexType getIndexType(IndexIdentifier identifier2, boolean recovery) {
        Pair<Integer, IndexType> type = this.cache.get(identifier2);
        Map<String, String> config = this.indexStore.get(identifier2.entityType.entityClass(), identifier2.indexName);
        if (type != null && config.hashCode() == type.first().intValue()) {
            return type.other();
        }
        if (config == null) {
            if (recovery) {
                return null;
            }
            throw new IllegalStateException("Unknown index " + identifier2);
        }
        type = Pair.of(config.hashCode(), IndexType.getIndexType(config));
        this.cache.put(identifier2, type);
        return type.other();
    }

    void invalidate(IndexIdentifier identifier2) {
        this.cache.remove(identifier2);
    }
}

