/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.ExactTxData;
import org.neo4j.index.impl.lucene.legacy.LowerCaseKeywordAnalyzer;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.LuceneLegacyIndex;
import org.neo4j.index.impl.lucene.legacy.LuceneUtil;
import org.neo4j.index.impl.lucene.legacy.TxData;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;

public abstract class IndexType {
    public static final IndexType EXACT = new IndexType(LuceneDataSource.KEYWORD_ANALYZER, false){

        @Override
        public Query get(String key, Object value) {
            return this.queryForGet(key, value);
        }

        @Override
        public void addToDocument(Document document, String key, Object value) {
            document.add(1.instantiateField(key, value, StringField.TYPE_STORED));
            document.add(1.instantiateSortField(key, value));
        }

        @Override
        void removeFieldsFromDocument(Document document, String key, Object value) {
            HashSet<String> values2 = null;
            if (value != null) {
                String stringValue = value.toString();
                values2 = new HashSet<String>(Arrays.asList(document.getValues(key)));
                if (!values2.remove(stringValue)) {
                    return;
                }
            }
            document.removeFields(key);
            if (value != null) {
                for (String existingValue : values2) {
                    this.addToDocument(document, key, existingValue);
                }
            }
            this.restoreNumericFields(document);
        }

        public String toString() {
            return "EXACT";
        }
    };
    final Analyzer analyzer;
    private final boolean toLowerCase;

    private IndexType(Analyzer analyzer, boolean toLowerCase) {
        this.analyzer = analyzer;
        this.toLowerCase = toLowerCase;
    }

    static IndexType getIndexType(Map<String, String> config) {
        String type = config.get("type");
        IndexType result2 = null;
        Similarity similarity = IndexType.getCustomSimilarity(config);
        Boolean toLowerCaseUnbiased = config.get("to_lower_case") != null ? Boolean.valueOf(IndexType.parseBoolean(config.get("to_lower_case"), true)) : null;
        Analyzer customAnalyzer = IndexType.getCustomAnalyzer(config);
        if (type != null) {
            if (type.equals("exact")) {
                boolean toLowerCase = Boolean.TRUE.equals(toLowerCaseUnbiased);
                result2 = toLowerCase ? new CustomType((Analyzer)new LowerCaseKeywordAnalyzer(), true, similarity) : EXACT;
            } else if (type.equals("fulltext")) {
                boolean toLowerCase = !Boolean.FALSE.equals(toLowerCaseUnbiased);
                Analyzer analyzer = customAnalyzer;
                if (analyzer == null) {
                    analyzer = Boolean.TRUE.equals(toLowerCase) ? LuceneDataSource.LOWER_CASE_WHITESPACE_ANALYZER : LuceneDataSource.WHITESPACE_ANALYZER;
                }
                result2 = new CustomType(analyzer, toLowerCase, similarity);
            }
        } else {
            boolean toLowerCase;
            boolean bl = toLowerCase = !Boolean.FALSE.equals(toLowerCaseUnbiased);
            if (customAnalyzer == null) {
                throw new IllegalArgumentException("No 'type' was given (which can point out built-in analyzers, such as 'exact' and 'fulltext') and no 'analyzer' was given either (which can point out a custom " + Analyzer.class.getName() + " to use)");
            }
            result2 = new CustomType(customAnalyzer, toLowerCase, similarity);
        }
        return result2;
    }

    private static boolean parseBoolean(String string2, boolean valueIfNull) {
        return string2 == null ? valueIfNull : Boolean.parseBoolean(string2);
    }

    private static Similarity getCustomSimilarity(Map<String, String> config) {
        return IndexType.getByClassName(config, "similarity", Similarity.class);
    }

    private static Analyzer getCustomAnalyzer(Map<String, String> config) {
        return IndexType.getByClassName(config, "analyzer", Analyzer.class);
    }

    private static <T> T getByClassName(Map<String, String> config, String configKey, Class<T> cls) {
        String className = config.get(configKey);
        if (className != null) {
            try {
                return Class.forName(className).asSubclass(cls).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    abstract Query get(String var1, Object var2);

    TxData newTxData(LuceneLegacyIndex index) {
        return new ExactTxData(index);
    }

    Query query(String keyOrNull, Object value, QueryContext contextOrNull) {
        if (value instanceof Query) {
            return (Query)value;
        }
        QueryParser parser = new QueryParser(keyOrNull, this.analyzer);
        parser.setAllowLeadingWildcard(true);
        parser.setLowercaseExpandedTerms(this.toLowerCase);
        if (contextOrNull != null && contextOrNull.getDefaultOperator() != null) {
            parser.setDefaultOperator(contextOrNull.getDefaultOperator());
        }
        try {
            return parser.parse(value.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    abstract void addToDocument(Document var1, String var2, Object var3);

    public static IndexableField instantiateField(String key, Object value, FieldType fieldType) {
        Field field2;
        if (value instanceof Number) {
            Number number = (Number)value;
            field2 = value instanceof Long ? new LongField(key, number.longValue(), Field.Store.YES) : (value instanceof Float ? new FloatField(key, number.floatValue(), Field.Store.YES) : (value instanceof Double ? new DoubleField(key, number.doubleValue(), Field.Store.YES) : new IntField(key, number.intValue(), Field.Store.YES)));
        } else {
            field2 = new Field(key, value.toString(), fieldType);
        }
        return field2;
    }

    public static IndexableField instantiateSortField(String key, Object value) {
        Field field2;
        if (value instanceof Number) {
            Number number = (Number)value;
            field2 = value instanceof Float ? new SortedNumericDocValuesField(key, NumericUtils.floatToSortableInt(number.floatValue())) : (value instanceof Double ? new SortedNumericDocValuesField(key, NumericUtils.doubleToSortableLong(number.doubleValue())) : new SortedNumericDocValuesField(key, number.longValue()));
        } else {
            field2 = new SortedSetDocValuesField(key, new BytesRef(value.toString()));
        }
        return field2;
    }

    final void removeFromDocument(Document document, String key, Object value) {
        if (key == null && value == null) {
            this.clearDocument(document);
        } else {
            this.removeFieldsFromDocument(document, key, value);
        }
    }

    abstract void removeFieldsFromDocument(Document var1, String var2, Object var3);

    private void clearDocument(Document document) {
        HashSet<String> names = new HashSet<String>();
        for (IndexableField field2 : document.getFields()) {
            names.add(field2.name());
        }
        names.remove("_id_");
        for (String name2 : names) {
            document.removeFields(name2);
        }
    }

    protected void restoreNumericFields(Document document) {
        ArrayList<IndexableField> numericFields = new ArrayList<IndexableField>();
        for (IndexableField field2 : document.getFields()) {
            if (field2.numericValue() == null || field2.name().equals("_id_")) continue;
            numericFields.add(field2);
        }
        for (IndexableField field2 : numericFields) {
            document.removeField(field2.name());
            this.addToDocument(document, field2.name(), field2.numericValue());
        }
    }

    public static Document newBaseDocument(long entityId) {
        Document doc2 = new Document();
        doc2.add(new StringField("_id_", "" + entityId, Field.Store.YES));
        doc2.add(new NumericDocValuesField("_id_", entityId));
        return doc2;
    }

    public static Document newDocument(EntityId entityId) {
        Document document = IndexType.newBaseDocument(entityId.id());
        entityId.enhance(document);
        return document;
    }

    public Term idTerm(long entityId) {
        return new Term("_id_", "" + entityId);
    }

    Query idTermQuery(long entityId) {
        return new TermQuery(this.idTerm(entityId));
    }

    Similarity getSimilarity() {
        return null;
    }

    Query queryForGet(String key, Object value) {
        Object realValue;
        if (value instanceof ValueContext && (realValue = ((ValueContext)value).getValue()) instanceof Number) {
            Number number = (Number)realValue;
            return LuceneUtil.rangeQuery(key, number, number, true, true);
        }
        return new TermQuery(new Term(key, value.toString()));
    }

    private static class CustomType
    extends IndexType {
        private final Similarity similarity;

        CustomType(Analyzer analyzer, boolean toLowerCase, Similarity similarity) {
            super(analyzer, toLowerCase);
            this.similarity = similarity;
        }

        @Override
        Similarity getSimilarity() {
            return this.similarity;
        }

        @Override
        public Query get(String key, Object value) {
            return new TermQuery(new Term(this.exactKey(key), value.toString()));
        }

        private String exactKey(String key) {
            return key + "_e";
        }

        @Override
        public void addToDocument(Document document, String key, Object value) {
            document.add(new StringField(this.exactKey(key), value.toString(), Field.Store.YES));
            document.add(CustomType.instantiateField(key, value, TextField.TYPE_STORED));
            document.add(CustomType.instantiateSortField(key, value));
        }

        @Override
        void removeFieldsFromDocument(Document document, String key, Object value) {
            String exactKey = this.exactKey(key);
            HashSet<String> values2 = null;
            if (value != null) {
                String stringValue = value.toString();
                values2 = new HashSet<String>(Arrays.asList(document.getValues(exactKey)));
                if (!values2.remove(stringValue)) {
                    return;
                }
            }
            document.removeFields(exactKey);
            document.removeFields(key);
            if (value != null) {
                for (String existingValue : values2) {
                    this.addToDocument(document, key, existingValue);
                }
            }
            this.restoreNumericFields(document);
        }

        public String toString() {
            return "FULLTEXT";
        }
    }
}

