/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;

class IndexReference {
    private final IndexIdentifier identifier;
    private final IndexWriter writer;
    private final IndexSearcher searcher;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private boolean searcherIsClosed;
    private boolean writerIsClosed;
    private volatile boolean detached;
    private final AtomicBoolean stale = new AtomicBoolean();

    public IndexReference(IndexIdentifier identifier2, IndexSearcher searcher, IndexWriter writer) {
        this.identifier = identifier2;
        this.searcher = searcher;
        this.writer = writer;
    }

    public IndexSearcher getSearcher() {
        return this.searcher;
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public IndexIdentifier getIdentifier() {
        return this.identifier;
    }

    void incRef() {
        this.refCount.incrementAndGet();
    }

    public synchronized void dispose(boolean writerAlso) throws IOException {
        if (!this.searcherIsClosed) {
            this.searcher.getIndexReader().close();
            this.searcherIsClosed = true;
        }
        if (writerAlso && !this.writerIsClosed) {
            this.writer.close();
            this.writerIsClosed = true;
        }
    }

    public void detachOrClose() throws IOException {
        if (this.refCount.get() == 0) {
            this.dispose(false);
        } else {
            this.detached = true;
        }
    }

    synchronized boolean close() {
        try {
            if (this.searcherIsClosed || this.refCount.get() == 0) {
                return true;
            }
            boolean reallyClosed = false;
            if (this.refCount.decrementAndGet() <= 0 && this.detached) {
                this.dispose(false);
                reallyClosed = true;
            }
            return reallyClosed;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isClosed() {
        return this.searcherIsClosed;
    }

    boolean checkAndClearStale() {
        return this.stale.compareAndSet(true, false);
    }

    public synchronized void setStale() {
        this.stale.set(true);
    }
}

