/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.Collection;
import org.apache.lucene.document.Document;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.impl.lucene.legacy.AbstractLegacyIndexHits;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.IndexReference;

public class DocToIdIterator
extends AbstractLegacyIndexHits {
    private final Collection<EntityId> removedInTransactionState;
    private final EntityId.LongCostume idCostume = new EntityId.LongCostume();
    private IndexReference searcherOrNull;
    private final IndexHits<Document> source;
    private final PrimitiveLongSet idsModifiedInTransactionState;

    public DocToIdIterator(IndexHits<Document> source, Collection<EntityId> exclude, IndexReference searcherOrNull, PrimitiveLongSet idsModifiedInTransactionState) {
        this.source = source;
        this.removedInTransactionState = exclude;
        this.searcherOrNull = searcherOrNull;
        this.idsModifiedInTransactionState = idsModifiedInTransactionState;
        if (source.size() == 0) {
            this.close();
        }
    }

    @Override
    protected boolean fetchNext() {
        while (this.source.hasNext()) {
            boolean idWillBeReturnedByTransactionStateInstead;
            Document doc2 = (Document)this.source.next();
            long id = DocToIdIterator.idFromDoc(doc2);
            boolean documentIsFromStore = doc2.getField("__tx_state__") == null;
            boolean bl = idWillBeReturnedByTransactionStateInstead = documentIsFromStore && this.idsModifiedInTransactionState.contains(id);
            if (this.removedInTransactionState.contains(this.idCostume.setId(id)) || idWillBeReturnedByTransactionStateInstead) continue;
            return this.next(id);
        }
        return this.endReached();
    }

    static long idFromDoc(Document doc2) {
        return Long.parseLong(doc2.get("_id_"));
    }

    protected boolean endReached() {
        this.close();
        return false;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.searcherOrNull.close();
            this.searcherOrNull = null;
        }
    }

    @Override
    public int size() {
        return Math.max(0, this.source.size() - this.removedInTransactionState.size());
    }

    private boolean isClosed() {
        return this.searcherOrNull == null;
    }

    @Override
    public float currentScore() {
        return this.source.currentScore();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

