/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.progress;

import java.io.PrintWriter;
import org.neo4j.helpers.progress.ProgressMonitorFactory;

public abstract class Indicator {
    static final OpenEnded NONE = new OpenEnded(1){

        @Override
        protected void progress(int from2, int to2) {
        }
    };
    private final int reportResolution;

    public Indicator(int reportResolution) {
        this.reportResolution = reportResolution;
    }

    protected abstract void progress(int var1, int var2);

    int reportResolution() {
        return this.reportResolution;
    }

    public void startProcess(long totalCount) {
    }

    public void startPart(String part, long totalCount) {
    }

    public void completePart(String part) {
    }

    public void completeProcess() {
    }

    public void failure(Throwable cause) {
    }

    static class OpenEndedTextual
    extends OpenEnded {
        private final String process;
        private final PrintWriter out;
        private int dots;

        OpenEndedTextual(String process, PrintWriter out, int reportResolution) {
            super(reportResolution);
            this.process = process;
            this.out = out;
        }

        @Override
        public void startProcess(long totalCount) {
            this.out.println(this.process);
            this.out.flush();
        }

        @Override
        public void completeProcess() {
            for (int i = this.dots; i < 20; ++i) {
                this.out.print(" ");
            }
            this.out.println("    done");
            this.out.flush();
        }

        @Override
        protected void progress(int from2, int to2) {
            int i = from2;
            while (i < to2) {
                this.printProgress(++i);
            }
            this.out.flush();
        }

        @Override
        public void failure(Throwable cause) {
            cause.printStackTrace(this.out);
        }

        private void printProgress(int progress) {
            this.out.print('.');
            ++this.dots;
            if (progress % 20 == 0) {
                this.out.printf(" %7d%n", (long)progress * (long)this.reportResolution());
                this.dots = 0;
            }
        }
    }

    static class Textual
    extends Indicator {
        private final String process;
        private final PrintWriter out;

        Textual(String process, PrintWriter out) {
            super(200);
            this.process = process;
            this.out = out;
        }

        @Override
        public void startProcess(long totalCount) {
            this.out.println(this.process);
            this.out.flush();
        }

        @Override
        protected void progress(int from2, int to2) {
            int i = from2;
            while (i < to2) {
                this.printProgress(++i);
            }
            this.out.flush();
        }

        @Override
        public void failure(Throwable cause) {
            cause.printStackTrace(this.out);
        }

        private void printProgress(int progress) {
            this.out.print('.');
            if (progress % 20 == 0) {
                this.out.printf(" %3d%%%n", progress / 2);
            }
        }
    }

    public static abstract class Decorator
    extends OpenEnded {
        private final Indicator indicator;

        public Decorator(ProgressMonitorFactory factory, String process) {
            this(factory.newIndicator(process));
        }

        public Decorator(ProgressMonitorFactory factory, String process, int resolution) {
            this(factory.newOpenEndedIndicator(process, resolution));
        }

        public Decorator(Indicator indicator) {
            super(indicator.reportResolution());
            this.indicator = indicator;
        }

        @Override
        public void startProcess(long totalCount) {
            this.indicator.startProcess(totalCount);
        }

        @Override
        public void startPart(String part, long totalCount) {
            this.indicator.startPart(part, totalCount);
        }

        @Override
        public void completePart(String part) {
            this.indicator.completePart(part);
        }

        @Override
        public void completeProcess() {
            this.indicator.completeProcess();
        }

        @Override
        protected void progress(int from2, int to2) {
            this.indicator.progress(from2, to2);
        }

        @Override
        public void failure(Throwable cause) {
            this.indicator.failure(cause);
        }
    }

    public static abstract class OpenEnded
    extends Indicator {
        public OpenEnded(int reportResolution) {
            super(reportResolution);
        }
    }
}

