/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

public abstract class Pair<T1, T2> {
    private static final Pair EMPTY = Pair.of(null, null);

    public static <T1, T2> Pair<T1, T2> empty() {
        return EMPTY;
    }

    public static <T1, T2> Pair<T1, T2> pair(final T1 first, final T2 other2) {
        return new Pair<T1, T2>(){

            @Override
            public T1 first() {
                return first;
            }

            @Override
            public T2 other() {
                return other2;
            }
        };
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 other2) {
        return Pair.pair(first, other2);
    }

    Pair() {
    }

    public abstract T1 first();

    public abstract T2 other();

    public String toString() {
        return "(" + this.first() + ", " + this.other() + ")";
    }

    public int hashCode() {
        return 31 * Pair.hashCode(this.first()) | Pair.hashCode(this.other());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair that = (Pair)obj;
            return Pair.equals(this.other(), that.other()) && Pair.equals(this.first(), that.first());
        }
        return false;
    }

    static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    static boolean equals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }
}

