/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import java.util.function.Function;

class MapIterable<FROM, TO>
implements Iterable<TO> {
    private final Iterable<FROM> from;
    private final Function<? super FROM, ? extends TO> function;

    public MapIterable(Iterable<FROM> from2, Function<? super FROM, ? extends TO> function) {
        this.from = from2;
        this.function = function;
    }

    @Override
    public Iterator<TO> iterator() {
        return new MapIterator<FROM, TO>(this.from.iterator(), this.function);
    }

    static class MapIterator<FROM, TO>
    implements Iterator<TO> {
        private final Iterator<FROM> fromIterator;
        private final Function<? super FROM, ? extends TO> function;

        public MapIterator(Iterator<FROM> fromIterator2, Function<? super FROM, ? extends TO> function) {
            this.fromIterator = fromIterator2;
            this.function = function;
        }

        @Override
        public boolean hasNext() {
            return this.fromIterator.hasNext();
        }

        @Override
        public TO next() {
            FROM from2 = this.fromIterator.next();
            return this.function.apply(from2);
        }

        @Override
        public void remove() {
            this.fromIterator.remove();
        }
    }
}

