/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.CombiningResourceIterator;
import org.neo4j.helpers.collection.FilterIterable;
import org.neo4j.helpers.collection.MapIterable;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.helpers.collection.RawMapIterator;
import org.neo4j.helpers.collection.WrappingResourceIterator;

public abstract class Iterators {
    private static final ResourceIterator EMPTY_ITERATOR = new ResourceIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    };

    public static <T> T firstOrNull(Iterator<T> iterator2) {
        return iterator2.hasNext() ? (T)iterator2.next() : null;
    }

    public static <T> T first(Iterator<T> iterator2) {
        return Iterators.assertNotNull(iterator2, Iterators.firstOrNull(iterator2));
    }

    public static <T> T lastOrNull(Iterator<T> iterator2) {
        T result2 = null;
        while (iterator2.hasNext()) {
            result2 = iterator2.next();
        }
        return result2;
    }

    public static <T> T last(Iterator<T> iterator2) {
        return Iterators.assertNotNull(iterator2, Iterators.lastOrNull(iterator2));
    }

    public static <T> T singleOrNull(Iterator<T> iterator2) {
        return Iterators.single(iterator2, null);
    }

    public static <T> T single(Iterator<T> iterator2) {
        return Iterators.assertNotNull(iterator2, Iterators.singleOrNull(iterator2));
    }

    public static <T> T fromEnd(Iterator<T> iterator2, int n) {
        return Iterators.assertNotNull(iterator2, Iterators.fromEndOrNull(iterator2, n));
    }

    public static <T> T fromEndOrNull(Iterator<T> iterator2, int n) {
        ArrayDeque<T> trail = new ArrayDeque<T>(n);
        while (iterator2.hasNext()) {
            if (trail.size() > n) {
                trail.removeLast();
            }
            trail.addFirst(iterator2.next());
        }
        return trail.size() == n + 1 ? (T)trail.getLast() : null;
    }

    public static boolean iteratorsEqual(Iterator<?> first, Iterator<?> other2) {
        while (first.hasNext() && other2.hasNext()) {
            if (first.next().equals(other2.next())) continue;
            return false;
        }
        return first.hasNext() == other2.hasNext();
    }

    private static <T> T assertNotNull(Iterator<T> iterator2, T result2) {
        if (result2 == null) {
            throw new NoSuchElementException("No element found in " + iterator2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T single(Iterator<T> iterator2, T itemIfNone) {
        try {
            T result2;
            T t = result2 = iterator2.hasNext() ? iterator2.next() : itemIfNone;
            if (iterator2.hasNext()) {
                throw new NoSuchElementException("More than one element in " + iterator2 + ". First element is '" + result2 + "' and the second element is '" + iterator2.next() + "'");
            }
            T t2 = result2;
            return t2;
        }
        finally {
            if (iterator2 instanceof Resource) {
                ((Resource)((Object)iterator2)).close();
            }
        }
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator2, C collection) {
        while (iterator2.hasNext()) {
            collection.add(iterator2.next());
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterator<T> iterator2, C collection) {
        while (iterator2.hasNext()) {
            Iterators.addUnique(collection, iterator2.next());
        }
        return collection;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterable<T> iterable, C collection) {
        return Iterators.addToCollectionUnique(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> loop(Iterator<T> iterator2) {
        return () -> iterator2;
    }

    public static <T> Iterable<T> asIterable(Iterator<T> iterator2) {
        return Iterators.loop(iterator2);
    }

    public static <T> long count(Iterator<T> iterator2) {
        return Iterators.count(iterator2, Predicates.alwaysTrue());
    }

    public static <T> long count(Iterator<T> iterator2, Predicate<T> filter2) {
        long result2 = 0L;
        while (iterator2.hasNext()) {
            if (!filter2.test(iterator2.next())) continue;
            ++result2;
        }
        return result2;
    }

    public static <T> Collection<T> asCollection(Iterator<T> iterable) {
        return Iterators.addToCollection(iterable, new ArrayList());
    }

    public static <T> List<T> asList(Iterator<T> iterator2) {
        return Iterators.addToCollection(iterator2, new ArrayList());
    }

    public static <T, EX extends Exception> List<T> asList(RawIterator<T, EX> iterator2) throws EX {
        ArrayList<T> out = new ArrayList<T>();
        while (iterator2.hasNext()) {
            out.add(iterator2.next());
        }
        return out;
    }

    public static <T> Set<T> asSet(Iterator<T> iterator2) {
        return Iterators.addToCollection(iterator2, new HashSet());
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <T> Set<T> emptySetOf(Class<T> type) {
        return Collections.emptySet();
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... items) {
        return Iterators.asSet(items);
    }

    @SafeVarargs
    public static <T> Set<T> asUniqueSet(T ... items) {
        HashSet set = new HashSet();
        for (T item : items) {
            Iterators.addUnique(set, item);
        }
        return set;
    }

    public static <T> Set<T> asUniqueSet(Iterator<T> items) {
        HashSet set = new HashSet();
        while (items.hasNext()) {
            Iterators.addUnique(set, items.next());
        }
        return set;
    }

    public static Iterator<Long> asIterator(final long ... array) {
        return new PrefetchingIterator<Long>(){
            private int index;

            @Override
            protected Long fetchNextOrNull() {
                try {
                    Long l = this.index < array.length ? Long.valueOf(array[this.index]) : null;
                    return l;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> asIterator(final int maxItems, final T ... array) {
        return new PrefetchingIterator<T>(){
            private int index;

            @Override
            protected T fetchNextOrNull() {
                try {
                    Object object = this.index < array.length && this.index < maxItems ? array[this.index] : null;
                    return object;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static <T> Iterator<T> iterator(final T item) {
        if (item == null) {
            return Iterators.emptyIterator();
        }
        return new Iterator<T>(){
            T myItem;
            {
                this.myItem = item;
            }

            @Override
            public boolean hasNext() {
                return this.myItem != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object toReturn = this.myItem;
                this.myItem = null;
                return toReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(T ... items) {
        return Iterators.asIterator(items.length, items);
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(int maxItems, T ... items) {
        return Iterators.asIterator(maxItems, items);
    }

    public static <T> ResourceIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean contains(Iterator<T> iterator2, T item) {
        try {
            for (T element : Iterators.loop(iterator2)) {
                if (!(item == null ? element == null : item.equals(element))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (iterator2 instanceof ResourceIterator) {
                ((ResourceIterator)iterator2).close();
            }
        }
    }

    public static <T> ResourceIterator<T> asResourceIterator(Iterator<T> iterator2) {
        if (iterator2 instanceof ResourceIterator) {
            return (ResourceIterator)iterator2;
        }
        return new WrappingResourceIterator<T>(iterator2);
    }

    public static <T> ResourceIterator<T> resourceIterator(final Iterator<T> iterator2, final Resource resource) {
        return new PrefetchingResourceIterator<T>(){

            @Override
            public void close() {
                resource.close();
            }

            @Override
            protected T fetchNextOrNull() {
                return iterator2.hasNext() ? (Object)iterator2.next() : null;
            }
        };
    }

    @SafeVarargs
    public static <T> T[] array(T ... items) {
        return items;
    }

    public static <X> Iterator<X> filter(Predicate<? super X> specification, Iterator<X> i) {
        return new FilterIterable.FilterIterator<X>(i, specification);
    }

    public static <FROM, TO> Iterator<TO> map(Function<? super FROM, ? extends TO> function, Iterator<FROM> from2) {
        return new MapIterable.MapIterator<FROM, TO>(from2, function);
    }

    public static <FROM, TO, EX extends Exception> RawIterator<TO, EX> map(ThrowingFunction<? super FROM, ? extends TO, EX> function, RawIterator<FROM, EX> from2) {
        return new RawMapIterator<FROM, TO, EX>(from2, function);
    }

    public static <T, EX extends Exception> RawIterator<T, EX> asRawIterator(final Iterator<T> iter2) {
        return new RawIterator<T, EX>(){

            @Override
            public boolean hasNext() throws Exception {
                return iter2.hasNext();
            }

            @Override
            public T next() throws Exception {
                return iter2.next();
            }
        };
    }

    public static <FROM, TO> Iterator<TO> flatMap(Function<? super FROM, ? extends Iterator<TO>> function, Iterator<FROM> from2) {
        return new CombiningIterator(Iterators.map(function, from2));
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterators) {
        return Iterators.concat(Arrays.asList(iterators).iterator());
    }

    public static <T> ResourceIterator<T> concatResourceIterators(Iterator<ResourceIterator<T>> iterators) {
        return new CombiningResourceIterator<T>(iterators);
    }

    public static <T> Iterator<T> concat(Iterator<Iterator<T>> iterators) {
        return new CombiningIterator<T>(iterators);
    }

    public static <T> ResourceIterable<T> asResourceIterable(ResourceIterator<T> it) {
        return () -> it;
    }

    public static String join(String joinString, Iterator<?> iter2) {
        StringBuilder sb = new StringBuilder();
        while (iter2.hasNext()) {
            sb.append(iter2.next().toString());
            if (!iter2.hasNext()) continue;
            sb.append(joinString);
        }
        return sb.toString();
    }
}

