/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;

public class ProcessFailureException
extends Exception {
    private final Entry[] causes;

    public ProcessFailureException(List<Entry> causes) {
        super("Monitored process failed" + ProcessFailureException.message(causes), ProcessFailureException.cause(causes));
        this.causes = causes.toArray(new Entry[causes.size()]);
    }

    private static String message(List<Entry> causes) {
        if (causes.isEmpty()) {
            return ".";
        }
        if (causes.size() == 1) {
            return " in '" + causes.get(0).part + "'.";
        }
        StringBuilder result2 = new StringBuilder(":");
        for (Entry entry : causes) {
            result2.append("\n\t").append(entry);
        }
        return result2.toString();
    }

    private static Throwable cause(List<Entry> causes) {
        return causes.size() >= 1 ? causes.get(0).failure : null;
    }

    @Override
    public void printStackTrace(PrintStream s2) {
        super.printStackTrace(s2);
        this.printAllCauses(new PrintWriter(s2, true));
    }

    @Override
    public void printStackTrace(PrintWriter s2) {
        super.printStackTrace(s2);
        this.printAllCauses(s2);
    }

    public void printAllCauses(PrintWriter writer) {
        if (this.getCause() == null) {
            for (Entry entry : this.causes) {
                entry.failure.printStackTrace(writer);
            }
            writer.flush();
        }
    }

    public static final class Entry {
        private final String part;
        private final Throwable failure;

        public Entry(String part, Throwable failure) {
            this.part = part;
            this.failure = failure;
        }

        public String toString() {
            return "In '" + this.part + "': " + this.failure;
        }
    }
}

