/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphmatching;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphmatching.ArrayPropertyUtil;
import org.neo4j.graphmatching.PatternElement;
import org.neo4j.graphmatching.PatternFinder;
import org.neo4j.graphmatching.PatternGroup;
import org.neo4j.graphmatching.PatternMatch;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.graphmatching.filter.AbstractFilterExpression;
import org.neo4j.graphmatching.filter.FilterBinaryNode;
import org.neo4j.graphmatching.filter.FilterExpression;
import org.neo4j.graphmatching.filter.FilterValueGetter;
import org.neo4j.helpers.collection.FilteringIterable;

@Deprecated
public class PatternMatcher {
    private static PatternMatcher matcher = new PatternMatcher();

    private PatternMatcher() {
    }

    public static PatternMatcher getMatcher() {
        return matcher;
    }

    public Iterable<PatternMatch> match(PatternNode start, Node startNode) {
        return this.match(start, startNode, null);
    }

    public Iterable<PatternMatch> match(PatternNode start, Node startNode, Map<String, PatternNode> objectVariables) {
        return this.match(start, startNode, objectVariables, (Collection<PatternNode>)null);
    }

    public Iterable<PatternMatch> match(PatternNode start, Map<String, PatternNode> objectVariables, PatternNode ... optional2) {
        return this.match(start, objectVariables, Arrays.asList(optional2));
    }

    public Iterable<PatternMatch> match(PatternNode start, Map<String, PatternNode> objectVariables, Collection<PatternNode> optional2) {
        Node startNode = (Node)start.getAssociation();
        if (startNode == null) {
            throw new IllegalStateException("Associating node for start pattern node is null");
        }
        return this.match(start, startNode, objectVariables, optional2);
    }

    public Iterable<PatternMatch> match(PatternNode start, Node startNode, Map<String, PatternNode> objectVariables, Collection<PatternNode> optional2) {
        Node currentStartNode = (Node)start.getAssociation();
        if (currentStartNode != null && !currentStartNode.equals(startNode)) {
            throw new IllegalStateException("Start patter node already has associated " + currentStartNode + ", can not start with " + startNode);
        }
        Iterable<PatternMatch> result2 = null;
        result2 = optional2 == null || optional2.size() < 1 ? new PatternFinder(this, start, startNode) : new PatternFinder(this, start, startNode, false, optional2);
        if (objectVariables != null) {
            result2 = new FilteredPatternFinder(result2, objectVariables);
        }
        return result2;
    }

    public Iterable<PatternMatch> match(PatternNode start, Node startNode, Map<String, PatternNode> objectVariables, PatternNode ... optional2) {
        return this.match(start, startNode, objectVariables, Arrays.asList(optional2));
    }

    private static class FilteredPatternFinder
    extends FilteringIterable<PatternMatch> {
        public FilteredPatternFinder(Iterable<PatternMatch> source, Map<String, PatternNode> objectVariables) {
            super(source, (T item) -> {
                HashSet<PatternGroup> calculatedGroups = new HashSet<PatternGroup>();
                for (PatternElement element : item.getElements()) {
                    PatternNode node = element.getPatternNode();
                    PatternGroup group2 = node.getGroup();
                    if (!calculatedGroups.add(group2)) continue;
                    SimpleRegexValueGetter valueGetter = new SimpleRegexValueGetter(objectVariables, (PatternMatch)item, group2.getFilters());
                    for (FilterExpression expression : group2.getFilters()) {
                        if (expression.matches(valueGetter)) continue;
                        return false;
                    }
                }
                return true;
            });
        }
    }

    private static class SimpleRegexValueGetter
    implements FilterValueGetter {
        private PatternMatch match;
        private Map<String, PatternNode> labelToNode = new HashMap<String, PatternNode>();
        private Map<String, String> labelToProperty = new HashMap<String, String>();

        SimpleRegexValueGetter(Map<String, PatternNode> objectVariables, PatternMatch match, FilterExpression[] expressions2) {
            this.match = match;
            for (FilterExpression expression : expressions2) {
                this.mapFromExpression(expression);
            }
            this.labelToNode = objectVariables;
        }

        private void mapFromExpression(FilterExpression expression) {
            if (expression instanceof FilterBinaryNode) {
                FilterBinaryNode node = (FilterBinaryNode)expression;
                this.mapFromExpression(node.getLeftExpression());
                this.mapFromExpression(node.getRightExpression());
            } else {
                AbstractFilterExpression pattern = (AbstractFilterExpression)expression;
                this.labelToProperty.put(pattern.getLabel(), pattern.getProperty());
            }
        }

        public String[] getValues(String label) {
            PatternNode pNode = this.labelToNode.get(label);
            if (pNode == null) {
                throw new RuntimeException("No node for label '" + label + "'");
            }
            Node node = this.match.getNodeFor(pNode);
            String propertyKey = this.labelToProperty.get(label);
            if (propertyKey == null) {
                throw new RuntimeException("No property key for label '" + label + "'");
            }
            Object rawValue = node.getProperty(propertyKey, null);
            if (rawValue == null) {
                return new String[0];
            }
            Collection<Object> values2 = ArrayPropertyUtil.propertyValueToCollection(rawValue);
            String[] result2 = new String[values2.size()];
            int counter = 0;
            for (Object value : values2) {
                result2[counter++] = (String)value;
            }
            return result2;
        }
    }
}

