/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Paths;

public abstract class Sorting {
    private Sorting() {
    }

    public static Comparator<? super Path> endNodeProperty(final String propertyKey) {
        return new EndNodeComparator(){

            @Override
            protected int compareNodes(Node endNode1, Node endNode2) {
                Comparable p2;
                Comparable p1 = (Comparable)endNode1.getProperty(propertyKey);
                if (p1 == (p2 = (Comparable)endNode2.getProperty(propertyKey))) {
                    return 0;
                }
                if (p1 == null) {
                    return Integer.MIN_VALUE;
                }
                if (p2 == null) {
                    return Integer.MAX_VALUE;
                }
                return p1.compareTo(p2);
            }
        };
    }

    public static Comparator<? super Path> endNodeRelationshipCount(final PathExpander expander) {
        return new EndNodeComparator(){

            @Override
            protected int compareNodes(Node endNode1, Node endNode2) {
                Integer count1 = this.count(endNode1, expander);
                Integer count2 = this.count(endNode2, expander);
                return count1.compareTo(count2);
            }

            private Integer count(Node node, PathExpander expander2) {
                Iterator<Relationship> expand2 = expander2.expand(Paths.singleNodePath(node), BranchState.NO_STATE).iterator();
                int count2 = 0;
                while (expand2.hasNext()) {
                    ++count2;
                }
                return count2;
            }
        };
    }

    private static abstract class EndNodeComparator
    implements Comparator<Path> {
        private EndNodeComparator() {
        }

        @Override
        public int compare(Path p1, Path p2) {
            return this.compareNodes(p1.endNode(), p2.endNode());
        }

        protected abstract int compareNodes(Node var1, Node var2);
    }
}

