/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;

class PostorderDepthFirstSelector
implements BranchSelector {
    private TraversalBranch current;
    private final PathExpander expander;

    PostorderDepthFirstSelector(TraversalBranch startSource, PathExpander expander) {
        this.current = startSource;
        this.expander = expander;
    }

    @Override
    public TraversalBranch next(TraversalContext metadata) {
        TraversalBranch result2 = null;
        while (result2 == null) {
            if (this.current == null) {
                return null;
            }
            TraversalBranch next2 = this.current.next(this.expander, metadata);
            if (next2 != null) {
                this.current = next2;
                continue;
            }
            result2 = this.current;
            this.current = this.current.parent();
        }
        return result2;
    }
}

