/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

public enum Evaluation {
    INCLUDE_AND_CONTINUE(true, true),
    INCLUDE_AND_PRUNE(true, false),
    EXCLUDE_AND_CONTINUE(false, true),
    EXCLUDE_AND_PRUNE(false, false);

    private final boolean includes;
    private final boolean continues;

    private Evaluation(boolean includes2, boolean continues) {
        this.includes = includes2;
        this.continues = continues;
    }

    public boolean includes() {
        return this.includes;
    }

    public boolean continues() {
        return this.continues;
    }

    public static Evaluation of(boolean includes2, boolean continues) {
        return includes2 ? (continues ? INCLUDE_AND_CONTINUE : INCLUDE_AND_PRUNE) : (continues ? EXCLUDE_AND_CONTINUE : EXCLUDE_AND_PRUNE);
    }

    public static Evaluation ofIncludes(boolean includes2) {
        return includes2 ? INCLUDE_AND_CONTINUE : EXCLUDE_AND_CONTINUE;
    }

    public static Evaluation ofContinues(boolean continues) {
        return continues ? INCLUDE_AND_CONTINUE : INCLUDE_AND_PRUNE;
    }
}

