/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import java.util.function.Supplier;

public interface DependencyResolver {
    public <T> T resolveDependency(Class<T> var1) throws IllegalArgumentException;

    public <T> T resolveDependency(Class<T> var1, SelectionStrategy var2) throws IllegalArgumentException;

    public <T> Supplier<T> provideDependency(Class<T> var1, SelectionStrategy var2);

    public <T> Supplier<T> provideDependency(Class<T> var1);

    public static abstract class Adapter
    implements DependencyResolver {
        private static final SelectionStrategy FIRST = new SelectionStrategy(){

            @Override
            public <T> T select(Class<T> type, Iterable<T> candidates2) throws IllegalArgumentException {
                Iterator<T> iterator2 = candidates2.iterator();
                if (!iterator2.hasNext()) {
                    throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
                }
                return iterator2.next();
            }
        };

        @Override
        public <T> T resolveDependency(Class<T> type) throws IllegalArgumentException {
            return this.resolveDependency(type, FIRST);
        }

        @Override
        public <T> Supplier<T> provideDependency(Class<T> type, SelectionStrategy selector) {
            return () -> this.resolveDependency(type, selector);
        }

        @Override
        public <T> Supplier<T> provideDependency(Class<T> type) {
            return () -> this.resolveDependency(type);
        }
    }

    public static interface SelectionStrategy {
        public <T> T select(Class<T> var1, Iterable<T> var2) throws IllegalArgumentException;
    }
}

