/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Iterator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class WeightedPathImpl
implements WeightedPath {
    private final Path path;
    private final double weight;

    public WeightedPathImpl(CostEvaluator<Double> costEvaluator, Path path) {
        this.path = path;
        double cost = 0.0;
        for (Relationship relationship : path.relationships()) {
            cost += costEvaluator.getCost(relationship, Direction.OUTGOING).doubleValue();
        }
        this.weight = cost;
    }

    public WeightedPathImpl(double weight, Path path) {
        this.path = path;
        this.weight = weight;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    @Override
    public Node startNode() {
        return this.path.startNode();
    }

    @Override
    public Node endNode() {
        return this.path.endNode();
    }

    @Override
    public Relationship lastRelationship() {
        return this.path.lastRelationship();
    }

    @Override
    public int length() {
        return this.path.length();
    }

    @Override
    public Iterable<Node> nodes() {
        return this.path.nodes();
    }

    @Override
    public Iterable<Node> reverseNodes() {
        return this.path.reverseNodes();
    }

    @Override
    public Iterable<Relationship> relationships() {
        return this.path.relationships();
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        return this.path.reverseRelationships();
    }

    @Override
    public String toString() {
        return this.path.toString() + " weight:" + this.weight;
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        return this.path.iterator();
    }
}

