/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.util.BestFirstSelectorFactory;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.traversal.TraversalBranch;

public class DijkstraSelectorFactory
extends BestFirstSelectorFactory<Double, Double> {
    private final CostEvaluator<Double> evaluator;

    public DijkstraSelectorFactory(PathInterest<Double> interest, CostEvaluator<Double> evaluator) {
        super(interest);
        this.evaluator = evaluator;
    }

    @Override
    protected Double calculateValue(TraversalBranch next2) {
        return next2.length() == 0 ? Double.valueOf(0.0) : this.evaluator.getCost(next2.lastRelationship(), Direction.OUTGOING);
    }

    @Override
    protected Double addPriority(TraversalBranch source, Double currentAggregatedValue, Double value) {
        return this.withDefault(currentAggregatedValue, 0.0) + this.withDefault(value, 0.0);
    }

    private <T> T withDefault(T valueOrNull, T valueIfNull) {
        return valueOrNull != null ? valueOrNull : valueIfNull;
    }

    @Override
    protected Double getStartData() {
        return 0.0;
    }
}

