/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.function.Predicate;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.util.WeightedPathImpl;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.impl.traversal.StandardBranchCollisionDetector;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.kernel.impl.util.MutableDouble;
import org.neo4j.kernel.impl.util.NoneStrictMath;

public class DijkstraBranchCollisionDetector
extends StandardBranchCollisionDetector {
    private final CostEvaluator costEvaluator;
    private final MutableDouble shortestSoFar;
    private final double epsilon;

    public DijkstraBranchCollisionDetector(Evaluator evaluator, CostEvaluator costEvaluator, MutableDouble shortestSoFar, double epsilon, Predicate<Path> pathPredicate) {
        super(evaluator, pathPredicate);
        this.costEvaluator = costEvaluator;
        this.shortestSoFar = shortestSoFar;
        this.epsilon = epsilon;
    }

    @Override
    protected boolean includePath(Path path, TraversalBranch startBranch, TraversalBranch endBranch) {
        if (!super.includePath(path, startBranch, endBranch)) {
            return false;
        }
        double cost = new WeightedPathImpl(this.costEvaluator, path).weight();
        if (cost < this.shortestSoFar.value) {
            this.shortestSoFar.value = cost;
        }
        return NoneStrictMath.compare(cost, this.shortestSoFar.value, this.epsilon) <= 0;
    }
}

