/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.util.MutableBoolean;
import org.neo4j.kernel.impl.util.MutableInteger;
import org.neo4j.kernel.monitoring.Monitors;

public class ShortestPath
implements PathFinder<Path> {
    public final int NULL = -1;
    private final int maxDepth;
    private final int maxResultCount;
    private final PathExpander expander;
    private Metadata lastMetadata;
    private ShortestPathPredicate predicate;
    private DataMonitor dataMonitor;

    public ShortestPath(int maxDepth2, PathExpander expander) {
        this(maxDepth2, expander, Integer.MAX_VALUE);
    }

    public ShortestPath(int maxDepth2, PathExpander expander, ShortestPathPredicate predicate) {
        this(maxDepth2, expander);
        this.predicate = predicate;
    }

    public ShortestPath(int maxDepth2, PathExpander expander, int maxResultCount) {
        this.maxDepth = maxDepth2;
        this.expander = expander;
        this.maxResultCount = maxResultCount;
    }

    @Override
    public Iterable<Path> findAllPaths(Node start, Node end) {
        return this.internalPaths(start, end, false);
    }

    @Override
    public Path findSinglePath(Node start, Node end) {
        Iterator<Path> paths = this.internalPaths(start, end, true).iterator();
        return paths.hasNext() ? paths.next() : null;
    }

    private void resolveMonitor(Node node) {
        GraphDatabaseService service;
        if (this.dataMonitor == null && (service = node.getGraphDatabase()) instanceof GraphDatabaseFacade) {
            Monitors monitors = ((GraphDatabaseFacade)service).getDependencyResolver().resolveDependency(Monitors.class);
            this.dataMonitor = monitors.newMonitor(DataMonitor.class, new String[0]);
        }
    }

    private Iterable<Path> internalPaths(Node start, Node end, boolean stopAsap) {
        this.lastMetadata = new Metadata();
        if (start.equals(end)) {
            return this.filterPaths(Collections.singletonList(PathImpl.singular(start)));
        }
        Hits hits = new Hits();
        HashSet<Long> sharedVisitedRels = new HashSet<Long>();
        MutableInteger sharedFrozenDepth = new MutableInteger(-1);
        MutableBoolean sharedStop = new MutableBoolean();
        MutableInteger sharedCurrentDepth = new MutableInteger(0);
        DirectionData startData = new DirectionData(start, sharedVisitedRels, sharedFrozenDepth, sharedStop, sharedCurrentDepth, this.expander);
        DirectionData endData = new DirectionData(end, sharedVisitedRels, sharedFrozenDepth, sharedStop, sharedCurrentDepth, this.expander.reverse());
        while (startData.hasNext() || endData.hasNext()) {
            this.goOneStep(startData, endData, hits, startData, stopAsap);
            this.goOneStep(endData, startData, hits, startData, stopAsap);
        }
        Collection<Hit> least = hits.least();
        return least != null ? this.filterPaths(ShortestPath.hitsToPaths(least, start, end, stopAsap)) : Collections.emptyList();
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastMetadata;
    }

    private void goOneStep(DirectionData directionData, DirectionData otherSide, Hits hits, DirectionData startSide, boolean stopAsap) {
        if (!directionData.hasNext()) {
            otherSide.finishCurrentLayerThenStop = true;
            return;
        }
        Node nextNode = (Node)directionData.next();
        LevelData otherSideHit = (LevelData)otherSide.visitedNodes.get(nextNode);
        if (otherSideHit != null) {
            int depth = directionData.currentDepth + otherSideHit.depth;
            if (((DirectionData)directionData).sharedFrozenDepth.value == -1) {
                ((DirectionData)directionData).sharedFrozenDepth.value = depth;
            }
            if (depth <= ((DirectionData)directionData).sharedFrozenDepth.value) {
                directionData.haveFoundSomething = true;
                if (depth < ((DirectionData)directionData).sharedFrozenDepth.value) {
                    ((DirectionData)directionData).sharedFrozenDepth.value = depth;
                    otherSide.stop = true;
                }
                DirectionData startSideData = directionData == startSide ? directionData : otherSide;
                DirectionData endSideData = directionData == startSide ? otherSide : directionData;
                Hit hit = new Hit(startSideData, endSideData, nextNode);
                Node start = startSide.startNode;
                Node end = startSide == directionData ? otherSide.startNode : directionData.startNode;
                this.monitorData(startSide, otherSide == startSide ? directionData : otherSide, nextNode);
                if (!stopAsap || this.filterPaths(ShortestPath.hitToPaths(hit, start, end, stopAsap)).size() > 0) {
                    if (hits.add(hit, depth) >= this.maxResultCount) {
                        directionData.stop = true;
                        otherSide.stop = true;
                        this.lastMetadata.paths++;
                    } else if (stopAsap) {
                        if (otherSide.stop) {
                            return;
                        }
                        directionData.stop = true;
                    }
                } else {
                    directionData.haveFoundSomething = false;
                    ((DirectionData)directionData).sharedFrozenDepth.value = -1;
                    otherSide.stop = false;
                }
            }
        }
    }

    private void monitorData(DirectionData directionData, DirectionData otherSide, Node connectingNode) {
        this.resolveMonitor(directionData.startNode);
        if (this.dataMonitor != null) {
            this.dataMonitor.monitorData(directionData.visitedNodes, directionData.nextNodes, otherSide.visitedNodes, otherSide.nextNodes, connectingNode);
        }
    }

    private Collection<Path> filterPaths(Collection<Path> paths) {
        if (this.predicate == null) {
            return paths;
        }
        ArrayList<Path> filteredPaths = new ArrayList<Path>();
        for (Path path : paths) {
            if (!this.predicate.test(path)) continue;
            filteredPaths.add(path);
        }
        return filteredPaths;
    }

    protected Node filterNextLevelNodes(Node nextNode) {
        return nextNode;
    }

    private static Collection<Path> hitsToPaths(Collection<Hit> depthHits, Node start, Node end, boolean stopAsap) {
        LinkedHashMap<String, Path> paths = new LinkedHashMap<String, Path>();
        for (Hit hit : depthHits) {
            for (Path path : ShortestPath.hitToPaths(hit, start, end, stopAsap)) {
                paths.put(path.toString(), path);
            }
        }
        return paths.values();
    }

    private static Collection<Path> hitToPaths(Hit hit, Node start, Node end, boolean stopAsap) {
        ArrayList<Path> paths = new ArrayList<Path>();
        Iterable<LinkedList<Relationship>> startPaths = ShortestPath.getPaths(hit.connectingNode, hit.start, stopAsap);
        Iterable<LinkedList<Relationship>> endPaths = ShortestPath.getPaths(hit.connectingNode, hit.end, stopAsap);
        for (LinkedList<Relationship> startPath : startPaths) {
            PathImpl.Builder startBuilder = ShortestPath.toBuilder(start, startPath);
            for (LinkedList<Relationship> endPath : endPaths) {
                PathImpl.Builder endBuilder = ShortestPath.toBuilder(end, endPath);
                Path path = startBuilder.build(endBuilder);
                paths.add(path);
            }
        }
        return paths;
    }

    private static Iterable<LinkedList<Relationship>> getPaths(Node connectingNode, DirectionData data, boolean stopAsap) {
        LevelData levelData = (LevelData)data.visitedNodes.get(connectingNode);
        if (levelData.depth == 0) {
            ArrayList<LinkedList<Relationship>> result2 = new ArrayList<LinkedList<Relationship>>();
            result2.add(new LinkedList());
            return result2;
        }
        ArrayList<PathData> set = new ArrayList<PathData>();
        GraphDatabaseService graphDb = data.startNode.getGraphDatabase();
        for (long rel : levelData.relsToHere) {
            set.add(new PathData(connectingNode, new LinkedList<Relationship>(Arrays.asList(graphDb.getRelationshipById(rel)))));
            if (stopAsap) break;
        }
        for (int i = 0; i < levelData.depth - 1; ++i) {
            ArrayList<PathData> nextSet = new ArrayList<PathData>();
            block2: for (PathData entry : set) {
                Node otherNode = ((Relationship)entry.rels.getFirst()).getOtherNode(entry.node);
                LevelData otherLevelData = (LevelData)data.visitedNodes.get(otherNode);
                int counter = 0;
                for (long rel : otherLevelData.relsToHere) {
                    LinkedList rels = ++counter == otherLevelData.relsToHere.length ? entry.rels : new LinkedList(entry.rels);
                    rels.addFirst(graphDb.getRelationshipById(rel));
                    nextSet.add(new PathData(otherNode, rels));
                    if (stopAsap) continue block2;
                }
            }
            set = nextSet;
        }
        return new IterableWrapper<LinkedList<Relationship>, PathData>(set){

            @Override
            protected LinkedList<Relationship> underlyingObjectToObject(PathData object) {
                return object.rels;
            }
        };
    }

    private static PathImpl.Builder toBuilder(Node startNode, LinkedList<Relationship> rels) {
        PathImpl.Builder builder = new PathImpl.Builder(startNode);
        for (Relationship rel : rels) {
            builder = builder.push(rel);
        }
        return builder;
    }

    private static class Metadata
    implements TraversalMetadata {
        private int rels;
        private int paths;

        private Metadata() {
        }

        @Override
        public int getNumberOfPathsReturned() {
            return this.paths;
        }

        @Override
        public int getNumberOfRelationshipsTraversed() {
            return this.rels;
        }
    }

    private static class PathData {
        private final LinkedList<Relationship> rels;
        private final Node node;

        PathData(Node node, LinkedList<Relationship> rels) {
            this.rels = rels;
            this.node = node;
        }
    }

    private static class Hits {
        private final Map<Integer, Collection<Hit>> hits = new HashMap<Integer, Collection<Hit>>();
        private int lowestDepth;
        private int totalHitCount;

        private Hits() {
        }

        int add(Hit hit, int atDepth) {
            Collection<Hit> depthHits = this.hits.get(atDepth);
            if (depthHits == null) {
                depthHits = new HashSet<Hit>();
                this.hits.put(atDepth, depthHits);
            }
            if (depthHits.add(hit)) {
                ++this.totalHitCount;
            }
            if (this.lowestDepth == 0 || atDepth < this.lowestDepth) {
                this.lowestDepth = atDepth;
            }
            return this.totalHitCount;
        }

        Collection<Hit> least() {
            return this.hits.get(this.lowestDepth);
        }
    }

    public static class LevelData {
        private long[] relsToHere;
        public final int depth;

        LevelData(Relationship relToHere, int depth) {
            if (relToHere != null) {
                this.addRel(relToHere);
            }
            this.depth = depth;
        }

        void addRel(Relationship rel) {
            long[] newRels = null;
            if (this.relsToHere == null) {
                newRels = new long[1];
            } else {
                newRels = new long[this.relsToHere.length + 1];
                System.arraycopy(this.relsToHere, 0, newRels, 0, this.relsToHere.length);
            }
            newRels[newRels.length - 1] = rel.getId();
            this.relsToHere = newRels;
        }
    }

    private static class DirectionDataPath
    implements Path {
        private final Node startNode;
        private Node endNode;
        private int length;

        DirectionDataPath(Node startNode) {
            this.startNode = startNode;
            this.endNode = startNode;
            this.length = 0;
        }

        void setEndNode(Node endNode) {
            this.endNode = endNode;
        }

        void setLength(int length2) {
            this.length = length2;
        }

        @Override
        public Node startNode() {
            return this.startNode;
        }

        @Override
        public Node endNode() {
            return this.endNode;
        }

        @Override
        public Relationship lastRelationship() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<Relationship> relationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<Relationship> reverseRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<Node> nodes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<Node> reverseNodes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public Iterator<PropertyContainer> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    private class DirectionData
    extends PrefetchingIterator<Node> {
        private boolean finishCurrentLayerThenStop;
        private final Node startNode;
        private int currentDepth;
        private Iterator<Relationship> nextRelationships;
        private final Collection<Node> nextNodes = new ArrayList<Node>();
        private final Map<Node, LevelData> visitedNodes = new HashMap<Node, LevelData>();
        private final Collection<Long> sharedVisitedRels;
        private final DirectionDataPath lastPath;
        private final MutableInteger sharedFrozenDepth;
        private final MutableBoolean sharedStop;
        private final MutableInteger sharedCurrentDepth;
        private boolean haveFoundSomething;
        private boolean stop;
        private final PathExpander expander;

        DirectionData(Node startNode, Collection<Long> sharedVisitedRels, MutableInteger sharedFrozenDepth, MutableBoolean sharedStop, MutableInteger sharedCurrentDepth, PathExpander expander) {
            this.startNode = startNode;
            this.visitedNodes.put(startNode, new LevelData(null, 0));
            this.nextNodes.add(startNode);
            this.sharedFrozenDepth = sharedFrozenDepth;
            this.sharedStop = sharedStop;
            this.sharedCurrentDepth = sharedCurrentDepth;
            this.expander = expander;
            this.sharedVisitedRels = sharedVisitedRels;
            this.lastPath = new DirectionDataPath(startNode);
            if (sharedCurrentDepth.value < ShortestPath.this.maxDepth) {
                this.prepareNextLevel();
            } else {
                this.nextRelationships = Collections.emptyList().iterator();
            }
        }

        private void prepareNextLevel() {
            ArrayList<Node> nodesToIterate = new ArrayList<Node>(this.nextNodes);
            this.nextNodes.clear();
            this.lastPath.setLength(this.currentDepth);
            this.nextRelationships = new NestingIterator<Relationship, Node>(nodesToIterate.iterator()){

                @Override
                protected Iterator<Relationship> createNestedIterator(Node node) {
                    DirectionData.this.lastPath.setEndNode(node);
                    return DirectionData.this.expander.expand(DirectionData.this.lastPath, BranchState.NO_STATE).iterator();
                }
            };
            ++this.currentDepth;
            ++this.sharedCurrentDepth.value;
        }

        @Override
        protected Node fetchNextOrNull() {
            Relationship nextRel;
            while ((nextRel = this.fetchNextRelOrNull()) != null) {
                Node result2 = nextRel.getOtherNode(this.lastPath.endNode());
                if (ShortestPath.this.filterNextLevelNodes(result2) == null) continue;
                ShortestPath.this.lastMetadata.rels++;
                LevelData levelData = this.visitedNodes.get(result2);
                if (levelData == null) {
                    levelData = new LevelData(nextRel, this.currentDepth);
                    this.visitedNodes.put(result2, levelData);
                    this.nextNodes.add(result2);
                    return result2;
                }
                if (this.currentDepth != levelData.depth) continue;
                levelData.addRel(nextRel);
            }
            return null;
        }

        private boolean canGoDeeper() {
            return this.sharedFrozenDepth.value == -1 && this.sharedCurrentDepth.value < ShortestPath.this.maxDepth && !this.finishCurrentLayerThenStop;
        }

        private Relationship fetchNextRelOrNull() {
            boolean hasComeTooFarEmptyHanded;
            if (this.stop || this.sharedStop.value) {
                return null;
            }
            boolean bl = hasComeTooFarEmptyHanded = this.sharedFrozenDepth.value != -1 && this.sharedCurrentDepth.value > this.sharedFrozenDepth.value && !this.haveFoundSomething;
            if (hasComeTooFarEmptyHanded) {
                return null;
            }
            if (!this.nextRelationships.hasNext() && this.canGoDeeper()) {
                this.prepareNextLevel();
            }
            return this.nextRelationships.hasNext() ? this.nextRelationships.next() : null;
        }
    }

    public static interface DataMonitor {
        public void monitorData(Map<Node, LevelData> var1, Collection<Node> var2, Map<Node, LevelData> var3, Collection<Node> var4, Node var5);
    }

    private static class Hit {
        private final DirectionData start;
        private final DirectionData end;
        private final Node connectingNode;

        Hit(DirectionData start, DirectionData end, Node connectingNode) {
            this.start = start;
            this.end = end;
            this.connectingNode = connectingNode;
        }

        public int hashCode() {
            return this.connectingNode.hashCode();
        }

        public boolean equals(Object obj) {
            Hit o = (Hit)obj;
            return this.connectingNode.equals(o.connectingNode);
        }
    }

    public static interface ShortestPathPredicate {
        public boolean test(Path var1);
    }
}

