/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.EigenvectorCentrality;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public abstract class EigenvectorCentralityBase
implements EigenvectorCentrality {
    protected final Direction relationDirection;
    protected final CostEvaluator<Double> costEvaluator;
    protected final Set<Relationship> relationshipSet;
    protected final double precision;
    protected Set<Node> nodeSet;
    protected boolean doneCalculation = false;
    protected Map<Node, Double> values;
    protected int totalIterations = 0;
    protected int maxIterations = Integer.MAX_VALUE;

    public EigenvectorCentralityBase(Direction relationDirection, CostEvaluator<Double> costEvaluator, Set<Node> nodeSet, Set<Relationship> relationshipSet, double precision) {
        this.relationDirection = relationDirection;
        this.costEvaluator = costEvaluator;
        this.nodeSet = nodeSet;
        this.relationshipSet = relationshipSet;
        this.precision = precision;
    }

    @Override
    public Double getCentrality(Node node) {
        if (!this.nodeSet.contains(node)) {
            return null;
        }
        if (!node.hasRelationship()) {
            return 0.0;
        }
        this.calculate();
        return this.values.get(node);
    }

    @Override
    public void reset() {
        this.doneCalculation = false;
    }

    @Override
    public void calculate() {
        if (this.doneCalculation) {
            return;
        }
        this.doneCalculation = true;
        this.runIterations(this.maxIterations);
    }

    protected int runIterations(int maxNrIterations) {
        int localIterations;
        block0: do {
            this.values = new HashMap<Node, Double>();
            this.totalIterations = 0;
            Random random = new Random(System.currentTimeMillis());
            for (Node node : this.nodeSet) {
                this.values.put(node, random.nextDouble());
            }
            this.normalize(this.values);
            if (maxNrIterations <= 0) {
                return 0;
            }
            for (localIterations = 0; localIterations < maxNrIterations; localIterations += this.runInternalIteration()) {
                Map<Node, Double> oldValues = this.values;
                if (!this.timeToStop(oldValues, this.values)) continue;
                continue block0;
            }
        } while (!this.makeSureValueCorrespondsToMostSignificantEigenvector());
        return localIterations;
    }

    private boolean makeSureValueCorrespondsToMostSignificantEigenvector() {
        int sign = 0;
        for (Node next2 : this.nodeSet) {
            int otherSign;
            Double value = this.values.get(next2);
            if (value == null) {
                this.values.put(next2, 0.0);
                value = 0.0;
            }
            if ((otherSign = value < -this.precision ? -1 : (value > this.precision ? 1 : 0)) == 0) continue;
            if (sign == 0) {
                sign = otherSign;
                continue;
            }
            if (sign == otherSign) continue;
            return false;
        }
        if (sign < 0) {
            for (Node node : this.nodeSet) {
                this.values.put(node, -this.values.get(node).doubleValue());
            }
        }
        return true;
    }

    protected abstract int runInternalIteration();

    public Map<Node, Double> processRelationships() {
        HashMap<Node, Double> newValues = new HashMap<Node, Double>();
        for (Relationship relationship : this.relationshipSet) {
            if (this.relationDirection.equals((Object)Direction.BOTH) || this.relationDirection.equals((Object)Direction.OUTGOING)) {
                this.processRelationship(newValues, relationship, false);
            }
            if (!this.relationDirection.equals((Object)Direction.BOTH) && !this.relationDirection.equals((Object)Direction.INCOMING)) continue;
            this.processRelationship(newValues, relationship, true);
        }
        return newValues;
    }

    protected void processRelationship(Map<Node, Double> newValues, Relationship relationship, boolean backwards) {
        Node startNode = backwards ? relationship.getEndNode() : relationship.getStartNode();
        Node endNode = relationship.getOtherNode(startNode);
        Double newValue = newValues.get(endNode);
        if (newValue == null) {
            newValue = 0.0;
        }
        if (this.values.get(startNode) != null) {
            newValue = newValue + this.values.get(startNode) * this.costEvaluator.getCost(relationship, backwards ? Direction.INCOMING : Direction.OUTGOING);
        }
        newValues.put(endNode, newValue);
    }

    protected double normalize(Map<Node, Double> vector) {
        double sum2 = 0.0;
        for (Node node : vector.keySet()) {
            Double d = vector.get(node);
            if (d == null) {
                d = 0.0;
                vector.put(node, 0.0);
            }
            sum2 += d * d;
        }
        if ((sum2 = Math.sqrt(sum2)) > 0.0) {
            for (Node node : vector.keySet()) {
                vector.put(node, vector.get(node) / sum2);
            }
        }
        return sum2;
    }

    private boolean timeToStop(Map<Node, Double> oldValues, Map<Node, Double> newValues) {
        for (Node node : oldValues.keySet()) {
            if (newValues.get(node) == null) {
                return false;
            }
            if (oldValues.get(node) == 0.0) {
                if (!(Math.abs(newValues.get(node)) > this.precision)) continue;
                return false;
            }
            double factor = newValues.get(node) / oldValues.get(node);
            if (!((factor = Math.abs(factor)) - this.precision > 1.0) && !(factor + this.precision < 1.0)) continue;
            return false;
        }
        return true;
    }

    protected void incrementTotalIterations() {
        ++this.totalIterations;
    }

    public int getTotalIterations() {
        return this.totalIterations;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

