/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.ancestor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Paths;

public class AncestorsUtil {
    public static Node lowestCommonAncestor(List<Node> nodeSet, PathExpander expander) {
        Node lowerCommonAncestor = null;
        if (nodeSet.size() > 1) {
            Node firstNode = nodeSet.get(0);
            LinkedList<Node> firstAncestors = AncestorsUtil.getAncestorsPlusSelf(firstNode, expander);
            for (int i = 1; i < nodeSet.size() && !firstAncestors.isEmpty(); ++i) {
                Node currentNode = nodeSet.get(i);
                AncestorsUtil.lookForCommonAncestor(firstAncestors, currentNode, expander);
            }
            if (!firstAncestors.isEmpty()) {
                lowerCommonAncestor = firstAncestors.get(0);
            }
        }
        return lowerCommonAncestor;
    }

    private static LinkedList<Node> getAncestorsPlusSelf(Node node, PathExpander expander) {
        LinkedList<Node> ancestors = new LinkedList<Node>();
        ancestors.add(node);
        Iterator<Relationship> relIterator = expander.expand(Paths.singleNodePath(node), BranchState.NO_STATE).iterator();
        while (relIterator.hasNext()) {
            Relationship rel = relIterator.next();
            node = rel.getOtherNode(node);
            ancestors.add(node);
            relIterator = expander.expand(Paths.singleNodePath(node), BranchState.NO_STATE).iterator();
        }
        return ancestors;
    }

    private static void lookForCommonAncestor(LinkedList<Node> commonAncestors, Node currentNode, PathExpander expander) {
        while (currentNode != null) {
            for (int i = 0; i < commonAncestors.size(); ++i) {
                Node node = commonAncestors.get(i);
                if (node.getId() != currentNode.getId()) continue;
                for (int j = 0; j < i; ++j) {
                    commonAncestors.pollFirst();
                }
                return;
            }
            Iterator<Relationship> relIt = expander.expand(Paths.singleNodePath(currentNode), BranchState.NO_STATE).iterator();
            if (relIt.hasNext()) {
                Relationship rel = relIt.next();
                currentNode = rel.getOtherNode(currentNode);
                continue;
            }
            currentNode = null;
        }
    }
}

