/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.internal.ExtendedExecutionResult;
import org.neo4j.cypher.internal.javacompat.Description;
import org.neo4j.cypher.internal.javacompat.PlanDescription;
import org.neo4j.cypher.internal.javacompat.QueryStatistics;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import scala.collection.JavaConversions;

public class ExecutionResult
implements ResourceIterable<Map<String, Object>>,
Result {
    private final ExtendedExecutionResult inner;
    private ResourceIterator<Map<String, Object>> innerIterator;

    public ExecutionResult(ExtendedExecutionResult projection2) {
        this.inner = Objects.requireNonNull(projection2);
        if (projection2.executionType().queryType() == QueryExecutionType.QueryType.WRITE) {
            this.innerIterator();
        }
    }

    @Override
    public <T> ResourceIterator<T> columnAs(String n) {
        try {
            return new ExceptionConversion(this.inner.javaColumnAs(n));
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    @Override
    public QueryExecutionType getQueryExecutionType() {
        try {
            return this.inner.executionType();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    @Override
    public List<String> columns() {
        try {
            return this.inner.javaColumns();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public String toString() {
        return this.inner.toString();
    }

    public String dumpToString() {
        return this.inner.dumpToString();
    }

    @Override
    public QueryStatistics getQueryStatistics() {
        try {
            return new QueryStatistics(this.inner.queryStatistics());
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    public PlanDescription executionPlanDescription() {
        return this.inner.executionPlanDescription().asJava();
    }

    public void toString(PrintWriter writer) {
        this.inner.dumpToString(writer);
        for (Notification notification : JavaConversions.asJavaIterable(this.inner.notifications())) {
            writer.println(notification.getDescription());
        }
    }

    @Override
    public ResourceIterator<Map<String, Object>> iterator() {
        return this.innerIterator();
    }

    @Override
    public Stream<Map<String, Object>> stream() {
        return this.iterator().stream();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.innerIterator().hasNext();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    @Override
    public Map<String, Object> next() {
        try {
            return (Map)this.innerIterator().next();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.innerIterator != null) {
                this.innerIterator.close();
            }
            this.inner.close();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    @Override
    public ExecutionPlanDescription getExecutionPlanDescription() {
        try {
            return new Description(this.inner.executionPlanDescription());
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    @Override
    public String resultAsString() {
        try {
            return this.dumpToString();
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    @Override
    public void writeAsStringTo(PrintWriter writer) {
        try {
            this.toString(writer);
        }
        catch (CypherException e) {
            throw ExecutionResult.converted(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <VisitationException extends Exception> void accept(Result.ResultVisitor<VisitationException> visitor) throws VisitationException {
        this.inner.accept(visitor);
    }

    @Override
    public Iterable<Notification> getNotifications() {
        return JavaConversions.asJavaIterable(this.inner.notifications());
    }

    private ResourceIterator<Map<String, Object>> innerIterator() {
        if (this.innerIterator == null) {
            this.innerIterator = this.inner.javaIterator();
        }
        return this.innerIterator;
    }

    private static QueryExecutionException converted(CypherException e) {
        return new QueryExecutionKernelException(e).asUserException();
    }

    private static class ExceptionConversion<T>
    implements ResourceIterator<T> {
        private final ResourceIterator<T> inner;

        public ExceptionConversion(ResourceIterator<T> inner2) {
            this.inner = inner2;
        }

        @Override
        public void close() {
            try {
                this.inner.close();
            }
            catch (CypherException e) {
                throw ExecutionResult.converted(e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.inner.hasNext();
            }
            catch (CypherException e) {
                throw ExecutionResult.converted(e);
            }
        }

        @Override
        public T next() {
            try {
                return (T)this.inner.next();
            }
            catch (CypherException e) {
                throw ExecutionResult.converted(e);
            }
        }

        @Override
        public void remove() {
            try {
                this.inner.remove();
            }
            catch (CypherException e) {
                throw ExecutionResult.converted(e);
            }
        }
    }
}

