/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.cypher.ProfilerStatisticsNotReadyException;
import org.neo4j.cypher.internal.ExtendedPlanDescription;
import org.neo4j.cypher.internal.PlanDescription;
import org.neo4j.cypher.internal.javacompat.ProfilerStatistics;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.helpers.Exceptions;
import scala.collection.JavaConversions;

class Description
implements ExecutionPlanDescription {
    private final PlanDescription description;

    public Description(PlanDescription description) {
        this.description = description;
    }

    public String toString() {
        return this.description.toString();
    }

    @Override
    public String getName() {
        return this.description.name();
    }

    @Override
    public List<ExecutionPlanDescription> getChildren() {
        ArrayList<ExecutionPlanDescription> result2 = new ArrayList<ExecutionPlanDescription>();
        for (PlanDescription child : JavaConversions.asJavaIterable(this.description.children())) {
            result2.add(new Description(child));
        }
        return result2;
    }

    @Override
    public Map<String, Object> getArguments() {
        return JavaConversions.mapAsJavaMap(this.description.arguments());
    }

    @Override
    public Set<String> getIdentifiers() {
        if (this.description instanceof ExtendedPlanDescription) {
            return JavaConversions.setAsJavaSet(((ExtendedPlanDescription)this.description).identifiers());
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasProfilerStatistics() {
        return this.description.hasProfilerStatistics();
    }

    @Override
    public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
        ProfilerStatistics statistics2;
        try {
            statistics2 = this.description.asJava().getProfilerStatistics();
        }
        catch (ProfilerStatisticsNotReadyException e) {
            throw Exceptions.withCause(new NoSuchElementException(e.getMessage()), e);
        }
        return new ExecutionPlanDescription.ProfilerStatistics(){

            @Override
            public long getRows() {
                return statistics2.getRows();
            }

            @Override
            public long getDbHits() {
                return statistics2.getDbHits();
            }

            public String toString() {
                return statistics2.toString();
            }
        };
    }
}

