/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_0.planner.logical.steps;

import org.neo4j.cypher.internal.compiler.v3_0.planner.CantHandleQueryException;
import org.neo4j.cypher.internal.compiler.v3_0.planner.PlannerQuery;
import org.neo4j.cypher.internal.compiler.v3_0.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.v3_0.planner.logical.PlanTransformer;
import org.neo4j.cypher.internal.compiler.v3_0.planner.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.compiler.v3_0.spi.PlanContext;
import org.neo4j.cypher.internal.frontend.v3_0.IndexHintException;
import org.neo4j.cypher.internal.frontend.v3_0.JoinHintException;
import org.neo4j.cypher.internal.frontend.v3_0.ast.Hint;
import org.neo4j.cypher.internal.frontend.v3_0.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_0.ast.PropertyKeyName;
import org.neo4j.cypher.internal.frontend.v3_0.ast.UsingIndexHint;
import org.neo4j.cypher.internal.frontend.v3_0.ast.UsingJoinHint;
import org.neo4j.cypher.internal.frontend.v3_0.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_0.notification.IndexHintUnfulfillableNotification;
import org.neo4j.cypher.internal.frontend.v3_0.notification.JoinHintUnfulfillableNotification;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class verifyBestPlan$
implements PlanTransformer<PlannerQuery> {
    public static final verifyBestPlan$ MODULE$;

    static {
        new verifyBestPlan$();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogicalPlan apply(LogicalPlan plan2, PlannerQuery expected, LogicalPlanningContext context) {
        void var4_4;
        block5: {
            block4: {
                PlannerQuery expectedWithoutHints;
                PlannerQuery constructed = plan2.solved();
                PlannerQuery plannerQuery = expected;
                PlannerQuery plannerQuery2 = constructed;
                if (!(plannerQuery == null ? plannerQuery2 != null : !plannerQuery.equals(plannerQuery2))) break block4;
                Set<UsingIndexHint> unfulfillableIndexHints = this.findUnfulfillableIndexHints(expected, context.planContext());
                Set<UsingJoinHint> unfulfillableJoinHints = this.findUnfulfillableJoinHints(expected, context.planContext());
                PlannerQuery plannerQuery3 = expectedWithoutHints = expected.withoutHints(unfulfillableIndexHints.$plus$plus(unfulfillableJoinHints, Set$.MODULE$.canBuildFrom()));
                PlannerQuery plannerQuery4 = constructed;
                if (plannerQuery3 != null ? !plannerQuery3.equals(plannerQuery4) : plannerQuery4 != null) break block5;
                this.processUnfulfilledIndexHints(context, unfulfillableIndexHints);
                this.processUnfulfilledJoinHints(context, unfulfillableJoinHints);
            }
            return plan2;
        }
        PlannerQuery plannerQuery = expected.withoutHints(expected.allHints());
        PlannerQuery plannerQuery5 = var4_4.withoutHints(var4_4.allHints());
        if (!(plannerQuery != null ? !plannerQuery.equals(plannerQuery5) : plannerQuery5 != null)) {
            throw new CantHandleQueryException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected \\n", " \\n\\n\\nInstead, got: \\n", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{expected.allHints(), var4_4.allHints()})));
        }
        throw new CantHandleQueryException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected \\n", " \\n\\n\\nInstead, got: \\n", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{expected, var4_4})));
    }

    private void processUnfulfilledIndexHints(LogicalPlanningContext context, Set<UsingIndexHint> hints) {
        if (hints.nonEmpty()) {
            if (context.useErrorsOverWarnings()) {
                UsingIndexHint firstIndexHint = (UsingIndexHint)hints.head();
                throw new IndexHintException(firstIndexHint.variable().name(), firstIndexHint.label().name(), firstIndexHint.property().name(), "No such index");
            }
            hints.foreach(new Serializable(context){
                public static final long serialVersionUID = 0L;
                private final LogicalPlanningContext context$1;

                public final void apply(UsingIndexHint hint) {
                    this.context$1.notificationLogger().log(new IndexHintUnfulfillableNotification(hint.label().name(), hint.property().name()));
                }
                {
                    this.context$1 = context$1;
                }
            });
        }
    }

    private void processUnfulfilledJoinHints(LogicalPlanningContext context, Set<UsingJoinHint> hints) {
        if (hints.nonEmpty()) {
            if (context.useErrorsOverWarnings()) {
                UsingJoinHint firstJoinHint = (UsingJoinHint)hints.head();
                throw new JoinHintException(firstJoinHint.variables().map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Variable x$1) {
                        return x$1.name();
                    }
                }).reduceLeft(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$2, String x$3) {
                        return new StringBuilder().append((Object)x$2).append((Object)", ").append((Object)x$3).toString();
                    }
                }), "Unable to plan hash join");
            }
            hints.foreach(new Serializable(context){
                public static final long serialVersionUID = 0L;
                private final LogicalPlanningContext context$2;

                public final void apply(UsingJoinHint hint) {
                    this.context$2.notificationLogger().log(new JoinHintUnfulfillableNotification(hint.variables().map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Variable x$4) {
                            return x$4.name();
                        }
                    }).toSeq()));
                }
                {
                    this.context$2 = context$2;
                }
            });
        }
    }

    private Set<UsingIndexHint> findUnfulfillableIndexHints(PlannerQuery query, PlanContext planContext) {
        return query.allHints().flatMap(new Serializable(planContext){
            public static final long serialVersionUID = 0L;
            private final PlanContext planContext$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Iterable<UsingIndexHint> apply(Hint x0$1) {
                void var10_13;
                boolean bl = false;
                UsingIndexHint usingIndexHint = null;
                Hint hint = x0$1;
                if (hint instanceof UsingIndexHint) {
                    bl = true;
                    usingIndexHint = (UsingIndexHint)hint;
                    Variable variable = usingIndexHint.variable();
                    LabelName labelName = usingIndexHint.label();
                    PropertyKeyName propertyKeyName = usingIndexHint.property();
                    if (variable != null && labelName != null) {
                        String property;
                        String label = labelName.name();
                        if (propertyKeyName != null && (this.planContext$1.getIndexRule(label, property = propertyKeyName.name()).isDefined() || this.planContext$1.getUniqueIndexRule(label, property).isDefined())) {
                            Iterable<Nothing$> iterable = Option$.MODULE$.option2Iterable(None$.MODULE$);
                            return var10_13;
                        }
                    }
                }
                if (bl) {
                    Variable variable = usingIndexHint.variable();
                    LabelName labelName = usingIndexHint.label();
                    PropertyKeyName propertyKeyName = usingIndexHint.property();
                    if (variable != null && labelName != null && propertyKeyName != null) {
                        Iterable<UsingIndexHint> iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(usingIndexHint));
                        return var10_13;
                    }
                }
                Iterable<Nothing$> iterable = Option$.MODULE$.option2Iterable(None$.MODULE$);
                return var10_13;
            }
            {
                this.planContext$1 = planContext$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private Set<UsingJoinHint> findUnfulfillableJoinHints(PlannerQuery query, PlanContext planContext) {
        return query.allHints().collect(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Hint, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof UsingJoinHint) {
                    UsingJoinHint usingJoinHint = (UsingJoinHint)A1;
                    object = usingJoinHint;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Hint x1) {
                Hint hint = x1;
                boolean bl = hint instanceof UsingJoinHint;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private verifyBestPlan$() {
        MODULE$ = this;
    }
}

