/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_0.executionplan;

import org.neo4j.cypher.internal.compiler.v3_0.CypherCompilerConfiguration;
import org.neo4j.cypher.internal.compiler.v3_0.ExecutionMode;
import org.neo4j.cypher.internal.compiler.v3_0.InternalNotificationLogger;
import org.neo4j.cypher.internal.compiler.v3_0.InterpretedRuntimeName$;
import org.neo4j.cypher.internal.compiler.v3_0.PlannerName;
import org.neo4j.cypher.internal.compiler.v3_0.PreparedQuerySemantics;
import org.neo4j.cypher.internal.compiler.v3_0.ProfileMode$;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.CheckForLoadCsvAndMatchOnLargeLabel;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.DefaultExecutionResultBuilderFactory;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.ExecutionPlan;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.ExecutionResultBuilder;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.ExecutionResultBuilderFactory;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.InternalExecutionResult;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.PeriodicCommitInfo;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.PipeInfo;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.PlanFingerprint;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.PlanFingerprintReference;
import org.neo4j.cypher.internal.compiler.v3_0.executionplan.checkForEagerLoadCsv$;
import org.neo4j.cypher.internal.compiler.v3_0.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v3_0.profiler.Profiler;
import org.neo4j.cypher.internal.compiler.v3_0.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v3_0.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v3_0.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v3_0.spi.UpdateCountingQueryContext;
import org.neo4j.cypher.internal.frontend.v3_0.PeriodicCommitInOpenTransactionException;
import org.neo4j.cypher.internal.frontend.v3_0.notification.InternalNotification;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class InterpretedExecutionPlanBuilder$ {
    public static final InterpretedExecutionPlanBuilder$ MODULE$;

    static {
        new InterpretedExecutionPlanBuilder$();
    }

    public ExecutionPlan interpretedToExecutionPlan(PipeInfo pipeInfo, PlanContext planContext, PreparedQuerySemantics inputQuery, Function1<Option<PlanFingerprint>, PlanFingerprintReference> createFingerprintReference, CypherCompilerConfiguration config, Function1<Object, Object> publicTypeConverter) {
        PipeInfo pipeInfo2 = pipeInfo;
        if (pipeInfo2 != null) {
            Tuple5<Pipe, Boolean, Option<PeriodicCommitInfo>, Option<PlanFingerprint>, PlannerName> tuple5;
            Pipe pipe = pipeInfo2.pipe();
            boolean updating = pipeInfo2.updating();
            Option<PeriodicCommitInfo> periodicCommitInfo = pipeInfo2.periodicCommit();
            Option<PlanFingerprint> fp = pipeInfo2.fingerprint();
            PlannerName planner = pipeInfo2.plannerUsed();
            Tuple5<Pipe, Boolean, Option<PeriodicCommitInfo>, Option<PlanFingerprint>, PlannerName> tuple52 = tuple5 = new Tuple5<Pipe, Boolean, Option<PeriodicCommitInfo>, Option<PlanFingerprint>, PlannerName>(pipe, BoxesRunTime.boxToBoolean(updating), periodicCommitInfo, fp, planner);
            Pipe pipe2 = tuple52._1();
            boolean updating2 = BoxesRunTime.unboxToBoolean(tuple52._2());
            Option<PeriodicCommitInfo> periodicCommitInfo2 = tuple52._3();
            Option<PlanFingerprint> fp2 = tuple52._4();
            PlannerName planner2 = tuple52._5();
            List<String> columns2 = inputQuery.statement().returnColumns();
            DefaultExecutionResultBuilderFactory resultBuilderFactory = new DefaultExecutionResultBuilderFactory(pipeInfo, columns2, publicTypeConverter);
            Function3<QueryContext, ExecutionMode, Map<String, Object>, InternalExecutionResult> func = this.getExecutionPlanFunction(periodicCommitInfo2, inputQuery.queryText(), updating2, resultBuilderFactory, inputQuery.notificationLogger());
            return new ExecutionPlan(createFingerprintReference, config, pipe2, periodicCommitInfo2, fp2, planner2, func){
                private final PlanFingerprintReference fingerprint;
                private final CypherCompilerConfiguration config$1;
                private final Pipe pipe$1;
                private final Option periodicCommitInfo$1;
                private final PlannerName planner$1;
                private final Function3 func$1;

                private PlanFingerprintReference fingerprint() {
                    return this.fingerprint;
                }

                public InternalExecutionResult run(QueryContext queryContext, ExecutionMode planType, Map<String, Object> params2) {
                    return (InternalExecutionResult)this.func$1.apply(queryContext, planType, params2);
                }

                public boolean isPeriodicCommit() {
                    return this.periodicCommitInfo$1.isDefined();
                }

                public PlannerName plannerUsed() {
                    return this.planner$1;
                }

                public boolean isStale(Function0<Object> lastTxId, GraphStatistics statistics2) {
                    return this.fingerprint().isStale(lastTxId, statistics2);
                }

                public InterpretedRuntimeName$ runtimeUsed() {
                    return InterpretedRuntimeName$.MODULE$;
                }

                public Seq<InternalNotification> notifications(PlanContext planContext) {
                    return InterpretedExecutionPlanBuilder$.MODULE$.org$neo4j$cypher$internal$compiler$v3_0$executionplan$InterpretedExecutionPlanBuilder$$checkForNotifications(this.pipe$1, planContext, this.config$1);
                }
                {
                    this.config$1 = config$1;
                    this.pipe$1 = pipe$1;
                    this.periodicCommitInfo$1 = periodicCommitInfo$1;
                    this.planner$1 = planner$1;
                    this.func$1 = func$1;
                    this.fingerprint = (PlanFingerprintReference)createFingerprintReference$1.apply(fp$1);
                }
            };
        }
        throw new MatchError(pipeInfo2);
    }

    public Seq<InternalNotification> org$neo4j$cypher$internal$compiler$v3_0$executionplan$InterpretedExecutionPlanBuilder$$checkForNotifications(Pipe pipe, PlanContext planContext, CypherCompilerConfiguration config) {
        Seq notificationCheckers = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{checkForEagerLoadCsv$.MODULE$, new CheckForLoadCsvAndMatchOnLargeLabel(planContext, config.nonIndexedLabelWarningThreshold())}));
        return notificationCheckers.flatMap(new Serializable(pipe){
            public static final long serialVersionUID = 0L;
            private final Pipe pipe$2;

            public final Iterable<InternalNotification> apply(Function1<Pipe, Option<InternalNotification>> x$2) {
                return Option$.MODULE$.option2Iterable(x$2.apply(this.pipe$2));
            }
            {
                this.pipe$2 = pipe$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Function3<QueryContext, ExecutionMode, Map<String, Object>, InternalExecutionResult> getExecutionPlanFunction(Option<PeriodicCommitInfo> periodicCommit, Object queryId, boolean updating, ExecutionResultBuilderFactory resultBuilderFactory, InternalNotificationLogger notificationLogger) {
        return new Serializable(periodicCommit, queryId, updating, resultBuilderFactory, notificationLogger){
            public static final long serialVersionUID = 0L;
            private final Option periodicCommit$1;
            private final Object queryId$1;
            private final boolean updating$1;
            private final ExecutionResultBuilderFactory resultBuilderFactory$1;
            private final InternalNotificationLogger notificationLogger$1;

            public final InternalExecutionResult apply(QueryContext queryContext, ExecutionMode planType, Map<String, Object> params2) {
                ExecutionResultBuilder builder = this.resultBuilderFactory$1.create();
                ExecutionMode executionMode = planType;
                ProfileMode$ profileMode$ = ProfileMode$.MODULE$;
                boolean profiling = !(executionMode != null ? !executionMode.equals(profileMode$) : profileMode$ != null);
                QueryContext builderContext = this.updating$1 || profiling ? new UpdateCountingQueryContext(queryContext) : queryContext;
                builder.setQueryContext(builderContext);
                if (this.periodicCommit$1.isDefined()) {
                    if (builderContext.transactionalContext().isTopLevelTx()) {
                        builder.setLoadCsvPeriodicCommitObserver(((PeriodicCommitInfo)this.periodicCommit$1.get()).batchRowCount());
                    } else {
                        throw new PeriodicCommitInOpenTransactionException();
                    }
                }
                if (profiling) {
                    builder.setPipeDecorator(new Profiler());
                }
                return builder.build(this.queryId$1, planType, params2, this.notificationLogger$1);
            }
            {
                this.periodicCommit$1 = periodicCommit$1;
                this.queryId$1 = queryId$1;
                this.updating$1 = updating$1;
                this.resultBuilderFactory$1 = resultBuilderFactory$1;
                this.notificationLogger$1 = notificationLogger$1;
            }
        };
    }

    private InterpretedExecutionPlanBuilder$() {
        MODULE$ = this;
    }
}

