/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;

public class CypherResultSubGraph
implements SubGraph {
    private final SortedMap<Long, Node> nodes = new TreeMap<Long, Node>();
    private final SortedMap<Long, Relationship> relationships = new TreeMap<Long, Relationship>();
    private final Collection<Label> labels = new HashSet<Label>();
    private final Collection<IndexDefinition> indexes = new HashSet<IndexDefinition>();
    private final Collection<ConstraintDefinition> constraints = new HashSet<ConstraintDefinition>();

    public void add(Node node) {
        long id = node.getId();
        if (!this.nodes.containsKey(id)) {
            this.addNode(id, node);
        }
    }

    void addNode(long id, Node data) {
        this.nodes.put(id, data);
        this.labels.addAll(Iterables.asCollection(data.getLabels()));
    }

    public void add(Relationship rel) {
        long id = rel.getId();
        if (!this.relationships.containsKey(id)) {
            this.addRel(id, rel);
            this.add(rel.getStartNode());
            this.add(rel.getEndNode());
        }
    }

    public static SubGraph from(Result result2, GraphDatabaseService gds, boolean addBetween) {
        CypherResultSubGraph graph = new CypherResultSubGraph();
        List<String> columns2 = result2.columns();
        for (Map<String, Object> map2 : Iterators.loop(result2)) {
            for (String column : columns2) {
                Object value = map2.get(column);
                graph.addToGraph(value);
            }
        }
        for (IndexDefinition indexDefinition : gds.schema().getIndexes()) {
            if (!graph.getLabels().contains(indexDefinition.getLabel())) continue;
            graph.addIndex(indexDefinition);
        }
        for (ConstraintDefinition constraintDefinition : gds.schema().getConstraints()) {
            if (!graph.getLabels().contains(constraintDefinition.getLabel())) continue;
            graph.addConstraint(constraintDefinition);
        }
        if (addBetween) {
            graph.addRelationshipsBetweenNodes();
        }
        return graph;
    }

    private void addIndex(IndexDefinition def) {
        this.indexes.add(def);
    }

    private void addConstraint(ConstraintDefinition def) {
        this.constraints.add(def);
    }

    private void addRelationshipsBetweenNodes() {
        HashSet<Node> newNodes = new HashSet<Node>();
        for (Node node : this.nodes.values()) {
            for (Relationship relationship : node.getRelationships()) {
                Node other2;
                if (!this.relationships.containsKey(relationship.getId()) || this.nodes.containsKey((other2 = relationship.getOtherNode(node)).getId()) || newNodes.contains(other2)) continue;
                newNodes.add(other2);
            }
        }
        for (Node node : newNodes) {
            this.add(node);
        }
    }

    private void addToGraph(Object value) {
        if (value instanceof Node) {
            this.add((Node)value);
        }
        if (value instanceof Relationship) {
            this.add((Relationship)value);
        }
        if (value instanceof Iterable) {
            for (Object inner2 : (Iterable)value) {
                this.addToGraph(inner2);
            }
        }
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.nodes.values();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.relationships.values();
    }

    public Collection<Label> getLabels() {
        return this.labels;
    }

    void addRel(Long id, Relationship rel) {
        this.relationships.put(id, rel);
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.relationships.containsKey(relationship.getId());
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return this.indexes;
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        return this.constraints;
    }
}

