/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SectionedCharBuffer;

public class MultiReadable
extends CharReadable.Adapter
implements Closeable {
    private final RawIterator<Reader, IOException> actual;
    private Reader current;
    private boolean requiresNewLine;
    private long position;
    private String currentSourceDescription = Readables.EMPTY.sourceDescription();

    public MultiReadable(RawIterator<Reader, IOException> actual2) throws IOException {
        this.actual = actual2;
        this.goToNextSource();
    }

    private boolean goToNextSource() throws IOException {
        if (this.actual.hasNext()) {
            this.closeCurrent();
            this.current = this.actual.next();
            this.currentSourceDescription = this.current.toString();
            return true;
        }
        return false;
    }

    @Override
    public SectionedCharBuffer read(SectionedCharBuffer buffer, int from2) throws IOException {
        buffer.compact(buffer, from2);
        while (this.current != null) {
            buffer.readFrom(this.current);
            if (buffer.hasAvailable()) {
                this.position += (long)buffer.available();
                char lastReadChar = buffer.array()[buffer.front() - 1];
                this.requiresNewLine = lastReadChar != '\n' && lastReadChar != '\r';
                return buffer;
            }
            if (this.requiresNewLine) {
                buffer.append('\n');
                ++this.position;
                this.requiresNewLine = false;
                return buffer;
            }
            if (this.goToNextSource()) continue;
            break;
        }
        return buffer;
    }

    private void closeCurrent() throws IOException {
        if (this.current != null) {
            this.current.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closeCurrent();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public String sourceDescription() {
        return this.currentSourceDescription;
    }
}

