/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.concurrent.Work;

public class WorkSync<Material, W extends Work<Material, W>> {
    private final Material material;
    private final AtomicReference<WorkUnit<Material, W>> stack;
    private final WorkUnit<Material, W> stackEnd;
    private final ReentrantLock lock;

    public WorkSync(Material material) {
        this.material = material;
        this.stackEnd = new WorkUnit(null, null);
        this.stack = new AtomicReference<WorkUnit<Material, W>>(this.stackEnd);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(W work) {
        WorkUnit unit = new WorkUnit((Work)work, null);
        unit.next = this.stack.getAndSet(unit);
        boolean wasInterrupted = false;
        int tryCount = 0;
        do {
            ++tryCount;
            try {
                if (!this.lock.tryLock(tryCount < 10 ? 0L : 10L, TimeUnit.MILLISECONDS)) continue;
                try {
                    this.doSynchronizedWork();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (!unit.done);
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void doSynchronizedWork() {
        WorkUnit<Material, W> batch = this.reverse(this.stack.getAndSet(this.stackEnd));
        W combinedWork = this.combine(batch);
        if (combinedWork != null) {
            combinedWork.apply(this.material);
        }
        this.markAsDone(batch);
    }

    private WorkUnit<Material, W> reverse(WorkUnit<Material, W> batch) {
        WorkUnit<Material, W> result2 = this.stackEnd;
        while (batch != this.stackEnd) {
            WorkUnit tmp = batch.next;
            while (tmp == null) {
                Thread.yield();
                tmp = batch.next;
            }
            batch.next = result2;
            result2 = batch;
            batch = tmp;
        }
        return result2;
    }

    private W combine(WorkUnit<Material, W> batch) {
        Work result2 = null;
        while (batch != this.stackEnd) {
            result2 = result2 == null ? (Work)batch.work : result2.combine(batch.work);
            batch = batch.next;
        }
        return (W)result2;
    }

    private void markAsDone(WorkUnit<Material, W> batch) {
        while (batch != this.stackEnd) {
            batch.done = true;
            batch = batch.next;
        }
    }

    private static class WorkUnit<Material, W extends Work<Material, W>> {
        final W work;
        volatile WorkUnit<Material, W> next;
        volatile boolean done;

        private WorkUnit(W work) {
            this.work = work;
        }

        /* synthetic */ WorkUnit(Work x0, 1 x1) {
            this(x0);
        }
    }
}

