/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Futures {
    @SafeVarargs
    public static <V> Future<List<V>> combine(Future<? extends V> ... futures) {
        return Futures.combine(Arrays.asList(futures));
    }

    public static <V> Future<List<V>> combine(final Iterable<? extends Future<? extends V>> futures) {
        return new Future<List<V>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result2 = false;
                for (Future future : futures) {
                    result2 |= future.cancel(mayInterruptIfRunning);
                }
                return result2;
            }

            @Override
            public boolean isCancelled() {
                boolean result2 = false;
                for (Future future : futures) {
                    result2 |= future.isCancelled();
                }
                return result2;
            }

            @Override
            public boolean isDone() {
                boolean result2 = false;
                for (Future future : futures) {
                    result2 |= future.isDone();
                }
                return result2;
            }

            @Override
            public List<V> get() throws InterruptedException, ExecutionException {
                ArrayList result2 = new ArrayList();
                for (Future future : futures) {
                    result2.add(future.get());
                }
                return result2;
            }

            @Override
            public List<V> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                ArrayList result2 = new ArrayList();
                for (Future future : futures) {
                    long before = System.nanoTime();
                    result2.add(future.get(timeout, unit));
                    timeout -= unit.convert(System.nanoTime() - before, TimeUnit.NANOSECONDS);
                }
                return result2;
            }
        };
    }
}

